#!/usr/bin/env bash

SSH_PUB_KEY_PROD="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIMOy8MFSZpVjX+9UPp1sJuUS9EbF2iU0+6gHsqQxnINJ OASI-PROD"

SSH_PUB_KEY_STAGE=""

NAME_GROUP_AND_USER="ansible-awx"
HOME_DIR="/home/$NAME_GROUP_AND_USER"
USER_SHELL="/bin/bash"
USER_COMMENT="DO NOT DELETE USER"
UID_GUID="2000"

#ssh-keygen -o -a 200 -t ed25519 -C "Comment"
SSH_KEY_FILE_PUB="authorized_keys"

#Name of the script to run
SCRIPT_NAME="$BASH_SOURCE"
[ -z "$BASH_SOURCE" ] && script_name="$0"

#Check root
if [ "$EUID" -ne 0 ]
then echo "Запустите скрипт $SCRIPT_NAME с привилегиями root"
exit 1
fi

#Check user
fnc_check_user(){
if [ id -u $NAME_GROUP_AND_USER > /dev/null 2>&1 ]
then echo "Пользователь $NAME_GROUP_AND_USER уже создан"
exit 1
fi
}

fnc_groupadd(){
groupadd -r -g "$UID_GUID" "$NAME_GROUP_AND_USER"
}

fnc_useradd(){
useradd -r -u "$UID_GUID" -g "$UID_GUID" -m -s "$USER_SHELL" -c "$USER_COMMENT" "$NAME_GROUP_AND_USER"
}

ssh_key_prod(){
mkdir -p $HOME_DIR/.ssh/
echo $SSH_PUB_KEY_PROD >> $HOME_DIR/.ssh/$SSH_KEY_FILE_PUB
chown -R $NAME_GROUP_AND_USER:$NAME_GROUP_AND_USER $HOME_DIR/.ssh/
chmod 0700 $HOME_DIR/.ssh
chmod 0600 $HOME_DIR/.ssh/$SSH_KEY_FILE_PUB

}

ssh_key_stage(){
mkdir -p $HOME_DIR/.ssh/
echo $SSH_PUB_KEY_STAGE >> $HOME_DIR/.ssh/$SSH_KEY_FILE_PUB
chown -R $NAME_GROUP_AND_USER:$NAME_GROUP_AND_USER $HOME_DIR/.ssh/
chmod 0700 $HOME_DIR/.ssh
chmod 0600 $HOME_DIR/.ssh/$SSH_KEY_FILE_PUB

}

case "$1" in

-stage|-lab) echo "Создание пользователя $NAME_GROUP_AND_USER для Stage/Lab"
fnc_check_user
fnc_groupadd
fnc_useradd
ssh_key_stage
;;


-prod|-predprod) echo "Создание пользователя $NAME_GROUP_AND_USER для Prod/Predprod"
fnc_check_user
fnc_groupadd
fnc_useradd
ssh_key_prod
;;

*) echo "Создание пользователя $NAME_GROUP_AND_USER"
echo "Использование:"
echo "запустите скрипт $SCRIPT_NAME и укажите название площадки"
echo "-stage - для lab/stage"
echo "-prod - для predprod/prod"
exit 1

esac
