<?php
$config = Config::getInstance(); 
$config->macrosFile = "macros";
$config->defaultController = 'index';
$config->adminUrl = '/admin';
$config->authClass = 'Lib_Auth';
$config->useLogin = true;
$config->useCache = false;
$config->useImageMagic = false;
$config->imageMagickPath = "/opt/local/bin/convert";

$config->server = "knigi.bibliogorod.ru";
$config->fromEmail = "knigi@bibliogorod.ru";
$config->fromName = 'Списанные книги';

$config->access = array(
	'index' => array(Roles::ADMIN),
    'history' => array(Roles::SUPER_USER),
	'order' => array(Roles::LIBRARY, Roles::CBS, Roles::MODERATOR, Roles::SUPER_USER),
	'users' => array(Roles::SUPER_USER, Roles::MODERATOR),
	'reviews' => array(Roles::SUPER_USER, Roles::MODERATOR, Roles::CBS),
	'export' => array(Roles::SUPER_USER, Roles::ADMIN, Roles::CBS),
	'funds' => array(Roles::SUPER_USER, Roles::ADMIN),
	'libraries' => array(Roles::SUPER_USER, Roles::ADMIN)
);

$config->menu = array('article', 'users', 'presets', 'import', 'order', 'reviews', 'export', 'history', 'funds', 'libraries');

Route_Router::addZone(trim($config->adminUrl, '/'));
Route_Router::add('/:controller/:action/*', array('controller' => $config->defaultController, 'action' => 'index'));
Route_Router::add('/logout', array('controller' => 'login', 'action' => 'logout'));
Route_Router::add('/login', array('controller' => 'login', 'action' => 'index'));
Route_Router::add('/auth', array('controller' => 'login', 'action' => 'form'));

?>
