<?php
class AdminController extends AppController
{
	protected $buttons = array();
	
	protected $pageTitle = '';
	
	protected $name = '';
	
	protected $baseUrl = '';
	
	protected $superUser = false;
	
	protected $presets;
	
	public function __construct()
	{
		parent::__construct();
		$this->superUser = Auth_Auth::getUser() != null && Auth_Auth::getUser()->isSuperAdmin();
		$this->presets = Presets_Dao::getPresets();
	}
	
	protected function skipAuth(){
		return false;
	}
	
	public function before()
	{
		if(!$this->skipAuth()){
			if(get_class($this) != 'LoginController' && (Auth_Auth::getUser() == null || !Auth_Auth::getUser()->isAdmin()))
				throw new Auth_AccessDeniedException();
			if(!Lib_App::checkAccess($this->route) && get_class($this) != 'LoginController')
				throw new Auth_AccessDeniedException();
		}
		$this->layout = 'main';
		$this->name = Route_Router::$route['controller'];
		$this->baseUrl = '/' . $this->name;
		parent::before();
	}
	
	public function after()
	{
		if($this->output)
		{
			$this->superUser = $this->superUser;
			View_View::getInstance()->buttons = $this->buttons;
			View_View::getInstance()->pageTitle = $this->pageTitle;
			View_View::getInstance()->presets = $this->presets;
			View_View::getInstance()->name = $this->name;
			View_View::getInstance()->baseUrl = Config::getInstance()->adminUrl;
			View_View::getInstance()->currentUser = Lib_Auth::getUser();
		}
		parent::after();
	}
	
	public static function navigate($address)
	{
		parent::navigate(Config::getInstance()->adminUrl.$address);
	}
	
	public static function registerInMenu()
	{
		return null;
	}
	 
	protected function registerButton($button)
	{
		if($button->url){
			if(strpos($button->url, '/') !== 0)
				$button->url = $this->baseUrl . '/' . $button->url;
			$button->url = Config::getInstance()->adminUrl . $button->url;
		}
		$this->buttons[] = $button;
		
	}
}
?>