<?php
class ArticleController extends AdminController 
{
	private $dao;
	
	public function __construct()
	{
		parent::__construct();
		$this->dao = new Article_Dao();
		$this->template = 'article';
		$this->title = $this->pageTitle = 'Страницы сайта';
	}
	
	public function index()
	{
		$this->getArticleMenu();
		$this->registerButton(new Lib_Button('new', '/article/add', 'Создать'));
		$parent = 0;
		if(isset($this->route['parent']))
			$parent = $this->route['parent'];
		$this->parent_id = $parent;
	}
	
	public function publish()
	{
		$this->output = false;
		$this->dao->publish(intval($this->route['id']));
	}
	
	public function ord()
	{
		$this->output = false;
		$article = $this->dao->get($this->route['id']);
		if($article)
			$this->dao->update($article->id, array('ord'=>intval($this->route['ord'])));
	}
	
	public function delete()
	{
		$this->output = false;
		$this->dao->delete(intval($this->route['id']));
	}
	
	public function add()
	{
		$this->getArticleMenu();
		$this->registerButton(new Lib_Button('save', '', 'Сохранить'));
		$this->registerButton(new Lib_Button('cancel', '/article', 'Отмена'));
		if(isset($this->route['parent']))
			$this->parent_id = $this->route['parent'];
		$this->partial = 'edit';
	}
	
	public function form($data)
	{
		$articleByUrl = $this->dao->getByUrl($data['url']);
		if ($articleByUrl != null && (!isset($data['id']) || $articleByUrl->id != $data['id']))
		{
			$this->addFormError('url', 'not.unique');
			return;
		}
		
		if(isset($data['id']))
		{
			$id = $data['id'];
			$this->dao->save($id, $data);
		}
		else 
		{
			$parent_id = 0;
			if(isset($data['parent_id']))
				$parent_id = $data['parent_id'];
			unset($data['parent_id']); 
			$id = $this->dao->create($parent_id, $data);
			$this->addFormData('id', $id);
		}
	}
	
	public function edit()
	{
		$article = $this->dao->get($this->route['id']);
		if($article == null)
			throw new PageNotFoundException();
		$this->getArticleMenu();
		$this->registerButton(new Lib_Button('save', '', 'Сохранить'));
		$this->registerButton(new Lib_Button('cancel', '/article', 'Отмена'));
		$this->article = $article;
	}
	
	public function uploadImage(){
		$this->output = false;
		App::setJsonHeaders();
		$imageDao = new Image_Dao();
		$image = $imageDao->upload(Config::getInstance()->slices["article_image"]);
		echo $image->serialize();
	}
	
	private function getArticleMenu()
	{
		$all = $this->dao->all(Db_Criteria::create()->field(array('id', 'ord', 'name', 'url', 'published', 'parent_id', 'code')));
		$articles = array();
		foreach($all as $a)
		{
			if(!isset($articles[$a->parent_id]))
				$articles[$a->parent_id] = array();
			$articles[$a->parent_id][] = $a;
		}
		foreach($articles as $parent_id => $children)
		{
			usort($children, array($this, 'sort'));
			$articles[$parent_id] = $children;
		}
		$this->articles = $articles;
	}
	
	private function sort($a1, $a2)
	{
		return $a1->ord < $a2->ord ? -1 : 1;
	}
	
	public static  function registerInMenu()
	{
		return new Lib_MenuItem('Страницы', '/article');
	}
}
?>