<?php
class ExportController extends AdminController
{
    private $dao;

    private $itemsPerPage = 50;

    private $folder = 'uploads/exports';

    public function __construct()
    {
        parent::__construct();
        $this->dao = new Export_Dao();
        $this->title = $this->pageTitle = "Выгрузка отчетов";
    }

    public function index()
    {
        $user = Auth_Auth::getUser();

        $page = $this->parsePage();
        $this->page = $page + 1;

        $this->exports = $this->dao->all(Db_Criteria::create(array('user_id' => $user->id))->order('created_at desc')->page($page)->perPage($this->itemsPerPage));
        $this->pages = ceil($this->dao->count() / $this->itemsPerPage);

    }

    public function download()
    {
        if(isset($this->route['uid'])){
            $userId = htmlentities($this->route['uid']);
        }
        if(isset($this->route['file'])){
            $fileName = htmlentities($this->route['file']);
        }

        $attachment_location = __DIR__.'/../../'.$this->folder . DIRECTORY_SEPARATOR . $userId . DIRECTORY_SEPARATOR;
        $fullFileName = $fileName.'.'.'xls';

        $attachment_location .= $fullFileName;
        if(file_exists($attachment_location)){
            header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
            header('Content-Type: text/html');
            header("Content-Transfer-Encoding: Binary");
            header("Content-disposition: attachment; filename=report-".$fullFileName);
            header("Cache-Control: no-cache, must-revalidate");
            readfile($attachment_location);
            exit;
        } else {
            echo "File not found!";
        }
    }

//    public function export(){
//        $this->output = false;
//        header("Content-Type: text/html");
//        header('Content-Disposition: attachment;filename="orders'.$this->route['type'].'-'.date('Y-m-d-H-i').'.xls"');
//        header('Cache-Control: max-age=0');
//
//        $user = Auth_Auth::getUser();
//
//        $lids = array();
//        $library = null;
//        $order = null;
//        $login = null;
//        if(isset($this->route['library'])){
//            $library = $this->libraryDao->get(intval($this->route['library']));
//        }
//        if(isset($this->route['order'])){
//            $order = intval($this->route['order']);
//        }
//        if(isset($_GET['login'])){
//            $login = htmlentities($_GET['login']);
//        }
//        $type = null;
//        if(isset($this->route['type'])){
//            $type = htmlentities($this->route['type']);
//        }
//        $libraryCriteria = Db_Criteria::create();//array('published' => 1)
//        if($user->isInRole(Roles::CBS)){
//            $libraryCriteria->add(Db_Exp::eq("cbs_sb_id", $user->cbs_id));
//        }
//        $libraries = $this->libraryDao->all($libraryCriteria->order('name asc'));
//        $map = array();
//        foreach($libraries as $l){
//            $lids[] = $l->id;
//            $map[$l->id] = $l;
//        }
//        $view = View_View::getInstance();
//        $view->exportUserData = !$user->isInRole(Roles::CBS);
//        $view->libraryMap = $map;
//        $view->libraries = $libraries;
//        $view->library = $library;
//        $view->order = $order;
//        $view->type = $type;
//        $view->login = $login;
//
//        $users = null;
//        if($login){
//            $sql = "select id from users where login like '%". mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $_GET['login']) . "%'";
//            $userDao = new User_Dao();
//            $users = $userDao->all(Db_Criteria::create()->sql($sql));
//        }
//
//        echo $view->renderFile('layouts/export/orders/header');
//        if($lids && ($login == null || $users)){
//            $sql = "select o.*, title, isbn from order_items o inner join books b on o.book_id = b.id where o.library_id in (".join(',', $lids).")";
//            if($library != null){
//                $sql .= " and o.library_id = " . $library;
//            }
//            if($order != null){
//                $sql .= " and order_id = " . $order;
//            }
//            if($type != null){
//                if($type == "waiting"){
//                    $sql .= " and o.status = '". Order_Status::NEW_ORDER . "'";
//                }
//                if($type == "processed"){
//                    $sql .= " and o.status = '". Order_Status::READY . "'";
//                }
//                if($type == "taken"){
//                    $sql .= " and o.status in ('". Order_Status::TAKEN . "', '".Order_Status::REFUSED."')";
//                }
//                if($type == "absent"){
//                    $sql .= " and o.status ='". Order_Status::ABSENT . "'";
//                }
//            }
//            if($users){
//                $ids = array();
//                foreach($users as $u){
//                    $ids[] = $u->id;
//                }
//                $sql .= " and user_id in (".join(',', $ids).")";
//            }
//            if($type == "waiting"){
//                $sql .= " order by IFNULL(left_time_start, now() + interval 100 day)";
//            }else{
//                $sql .= " order by o.id desc";
//            }
//            $baseSql = $sql;
//            $page = 0;
//            $perPage = 50;
//            do{
//                $sql = $baseSql . " limit " . ($page * $perPage) . ", " . $perPage;
//                $view->orders = $this->dao->all(Db_Criteria::create()->sql($sql));
//                echo $view->renderFile('layouts/export/orders/items');
//                $page ++;
//            }while($view->orders);
//
//        }else{
//            $view->orders = array();
//        }
//        if($view->orders){
//            $bookIds = array();
//            foreach($this->orders as $order){
//                $bookIds[] = $order->book_id;
//            }
//            $view->authors = Util::getAuthors($bookIds, $this->authorDao);
//        }
//        echo $view->renderFile('layouts/export/orders/footer');
//    }

//	public function report(){
//		header("Content-Type: text/html");
//		header('Content-Disposition: attachment;filename="report.xls"');
//		header('Cache-Control: max-age=0');
//		$this->layout = 'report';
//
//		$this->getReportData();
//
//		$this->view->cbsDao = new Cbs_Dao();
//		$this->view->libraryDao = $this->libraryDao;
//	}

//	private function getReportData(){
//		$from = strtotime($_GET['from']);
//		$to = strtotime($_GET['to']) + 3600 * 24;
//		$dates = array();
//		for($d = $from; $d < $to; $d += 3600 * 24){
//			$dates[] = date("d.m.Y", $d);
//		}
//		$criteria = Db_Criteria::create();
//		$criteria->add(Db_Exp::ge('date', date('Y-m-d', $from)));
//		$criteria->add(Db_Exp::lt('date', date('Y-m-d', $to)));
//		$criteria->order('date asc');
//
//		$result = array();
//		$page = 0;
//		do{
//			$items = $this->dao->all($criteria->page($page)->perPage(100));
//			$page ++;
//			foreach($items as $item){
//				$library = $item->library;
//				if(!isset($result[$library->cbs_sb_id])){
//					$result[$library->cbs_sb_id] = array();
//				}
//				if(!isset($result[$library->cbs_sb_id][$library->id])){
//					$result[$library->cbs_sb_id][$library->id] = array();
//				}
//				$line = $result[$library->cbs_sb_id][$library->id];
//				$date = date('d.m.Y', strtotime($item->date));
//				if(!isset($line[$date])){
//					$line[$date] = array('books' => 0, 'ready_books' => 0, 'absent_books' => 0, 'taken_books' => 0, 'refused_books' => 0, 'processed_at_time' => 0, 'processed_out_of_time' => 0);
//				}
//				$gap = $line[$date];
//				$gap['books']++;
//				if($item->status != Order_Status::ABSENT && $item->status != Order_Status::NEW_ORDER){
//					$gap['ready_books']++;
//				}
//				if($item->status == Order_Status::ABSENT){
//					$gap['absent_books']++;
//				}
//				if($item->status == Order_Status::TAKEN){
//					$gap['taken_books']++;
//				}
//				if($item->status == Order_Status::REFUSED){
//					$gap['refused_books']++;
//				}
//				if($item->processed_at){
//					$minutes = ceil((strtotime($item->processed_at) - strtotime($item->date)) / 60);
//					if($minutes > 30){
//						$gap['processed_out_of_time']++;
//					}else{
//						$gap['processed_at_time']++;
//					}
//				}
//				$line[$date] = $gap;
//				$result[$library->cbs_sb_id][$library->id] = $line;
//			}
//		}while($items);
//		$this->view->dates = $dates;
//		$this->view->result = $result;
//	}

//	public function export(){
//		header("Content-Type: text/html");
//		header('Content-Disposition: attachment;filename="reviews'.'-'.date('Y-m-d-H-i').'.xls"');
//		header('Cache-Control: max-age=0');
//		$this->layout = 'export/reviews';
//		$this->getReviews(true);
//	}

//	public function export(){
//		header("Content-Type: text/html");
//		header('Content-Disposition: attachment;filename="users'.'-'.date('Y-m-d-H-i').'.xls"');
//		header('Cache-Control: max-age=0');
//
//		$sql = "true";
//		if(isset($this->route['type'])){
//			$type = $this->route['type'];
//			if($type == 'registered'){
//				$sql .= " and roles like '%".Roles::USER."%' and roles not like '%".Roles::MODERATOR."%' and roles not like '%".Roles::ADMIN."%'";
//			}
//			if($type == 'directory'){
//				$sql .= " and (roles like '%".Roles::MODERATOR."%' || roles like '%".Roles::ADMIN."%' and roles not like '%".Roles::LRENTITY."%' and roles not like '%".Roles::ENTITY."%') and cbs_id is null and library_id is null";
//			}
//			if($type == 'lrentity'){
//				$sql.= " and roles like '%".Roles::LRENTITY."%'";
//			}
//			if($type == 'entity'){
//				$sql.= " and roles like '%".Roles::ENTITY."%'";
//			}
//			if($type == 'generic'){
//				$sql .= " and login like 'generic%'";
//			}
//			if($type == 'library'){
//				$sql .= " and library_id is not null";
//			}
//			if($type == 'cbs'){
//				$sql .= " and cbs_id is not null";
//			}
//		}
//
//		$this->layout = 'export/users';
//		$this->users = $this->dao->all(Db_Criteria::create()->add(Db_Exp::sql($sql)));
//	}

    public function delete()
    {
        $this->dao->delete($this->route['id']);
        $this->output = false;
    }

    public static function registerInMenu()
    {
        return new Lib_MenuItem('Отчеты', '/export', 5);
    }
}
?>