<?php

class HistoryController extends AdminController
{
    private $dao;

    private $bookDao;

    public function __construct()
    {
        parent::__construct();
        $this->dao = new Order_Log_Dao();
        $this->bookDao = new Book_Dao();
        $this->title = $this->pageTitle = "История заказов";
    }

    public function index()
    {
        $order = null;
        if(isset($this->route['order'])){
            $order = intval($this->route['order']);
        }
        $book = null;
        if(isset($this->route['book'])){
            $book = intval($this->route['book']);
        }

        $this->order = $order;
        $this->book = $book;

        $sql = "select o.*, title from orders_log o inner join books b on o.book_id = b.id where o.order_id = " . $order;
        $this->orderBooks = $this->dao->all(Db_Criteria::create()->sql($sql));

        $sql2 = "select o.*, title from orders_log o inner join books b on o.book_id = b.id where o.book_id = " . $book;
        $this->bookInOrder = $this->dao->all(Db_Criteria::create()->sql($sql2));

        $pageUrl = "/history/index";
        if($order){
            $pageUrl = "/history/index/order/".$order;
        }
        if($book){
            $pageUrl = "/history/index/book/".$book;
        }
        $this->pageUrl = $pageUrl;
    }

    public static function registerInMenu()
    {
        return new Lib_MenuItem("История заказов", "/history", 7);
    }
}