<?php
class ImportController extends AdminController
{
	private $dao;
	
	private $itemsPerPage = 50;
	
	private $folder = '/uploads/import';
	
	public function __construct()
	{
		parent::__construct();
		$this->dao = new Import_Dao();
		$this->title = $this->pageTitle = "Загрузка файлов";
	}
	
	public function index()
	{
		$page = $this->parsePage();
		$this->page = $page + 1;
		$this->imports = $this->dao->all(Db_Criteria::create()->order('id desc')->page($page)->perPage($this->itemsPerPage));
		$this->pages = ceil($this->dao->count() / $this->itemsPerPage);
	}
	
	public function upload($data)
	{
		$this->output = false;
		if(!isset($_FILES['file']) || $_FILES['file']['error'] || !$_FILES['file']['tmp_name']){
			self::navigate('/import?error=true');
			return;
		}
		$file = $_FILES['file']['tmp_name'];
		$name = md5($file);
		$path = $this->folder . '/' . $name . '.csv';
		if(!move_uploaded_file($file, SITE_DIR . $path)){
			self::navigate('/import?error=true');
			return null;
		}
		$this->dao->insert(array('date' => date("Y-m-d H:i:s"), 'file' => $path, 'fund' => $data['fund']));
		self::navigate('/import?success=true');
	}
	
	public function delete()
	{
		$this->dao->delete($this->route['id']);
		$this->output = false;
	}
	
	public static  function registerInMenu()
	{
		return new Lib_MenuItem("Импорт", "/import", 4);
	}
	
}
?>