<?php

class LibrariesController extends AdminController
{
    private $libraryDao;

    private $itemsPerPage = 50;

    public function __construct()
    {
        parent::__construct();
        $this->libraryDao = new Library_Dao();
        $this->title = $this->pageTitle = "Библиотеки";
    }

    public function index()
    {
        $page = $this->parsePage();
        $this->page = $page + 1;

        $this->libraries = $this->libraryDao->all(Db_Criteria::create()->page($page)->perPage($this->itemsPerPage));
        $this->pages = ceil($this->libraryDao->count() / $this->itemsPerPage);

        $pageUrl = "/libraries/index";

        $this->pageUrl = $pageUrl;
    }

    public function edit()
    {
        $library = $this->libraryDao->get($this->route['id']);

        $this->library = $library;

        $this->registerButton(new Lib_Button("save", "", 'Сохранить'));
    }

    public function form($data)
    {
        $libraryData = array('information' => $data['information']);

        $this->libraryDao->update($data['id'], $libraryData);
    }

    public static function registerInMenu()
    {
        return new Lib_MenuItem("Библиотеки", "/libraries", 9);
    }
}