<?php
class LoginController extends AdminController
{
	protected $userDao;
	
	public function __construct()
	{
		parent::__construct();
		$this->userDao = new User_Dao();
	}
	
	public function before()
	{
		parent::before();
		$this->layout = 'auth';
	}
	
	public function form($data)
	{
		if(!$data['login'])
		{
			$this->addFormError('login', 'required');
			return;
		}
		if(!$data['password'])
		{
			$this->addFormError('password', 'required');
			return;
		}
		$login = $data['login'];
		$password = md5($data['password']);
		$user = $this->userDao->getByLogin($login);
		if($user == null)
		{
			$this->addFormError('login', 'not.exists');
			return;
		}
		if($user->password != $password)
		{
			$this->addFormError('password', 'not.valid');
			return;
		}
		if($user->isblocked && $user->login != Config::getInstance()->superUserLogin)
		{
			$this->addFormError('login', 'blocked');
			return;
		}
		if(!$user->isInRole(Auth_Roles::ADMIN) && $user->login != Config::getInstance()->superUserLogin)
		{
			$this->addFormError('login', 'not.admin');
			return;
		}
		$remember = true;
		if(isset($data['remember']))
			$remember = $data['remember'];
		Auth_Auth::storeUser($user, $remember);
	}
	
	public function logout()
	{
		Auth_Auth::removeAuth();
		self::navigate('/login');
	}
}
?>