<?php
class OrderController extends AdminController
{
	private $dao;
	
	private $bookDao;
	
	private $authorDao;
	
	private $libraryDao;

	private $exportDao;

	private $orderDao;

	private $orderLogDao;
	
	private $itemsPerPage = 100;
	
	public function __construct()
	{
		parent::__construct();
		$this->dao = new Order_Item_Dao();
		$this->bookDao = new Book_Dao();
		$this->libraryDao = new Library_Dao();
		$this->authorDao = new Author_Dao();
		$this->exportDao = new Export_Dao();
		$this->orderDao = new Order_Dao();
		$this->orderLogDao = new Order_Log_Dao();
		$this->title = $this->pageTitle = "Заказанные книги";
	}
	
	public function index()
	{
		$user = Auth_Auth::getUser();
		$page = $this->parsePage();
		$this->page = $page + 1;
		
		$lids = array();
		$library = null;
		$order = null;
		$login = null;
		if(isset($this->route['library'])){
			$library = $this->libraryDao->get(intval($this->route['library']));
		}
		if(isset($this->route['order'])){
			$order = intval($this->route['order']);
		}
		if(isset($_GET['login'])){
			$login = htmlentities($_GET['login']);
		}
		$type = null;
		if(isset($this->route['type'])){
			$type = htmlentities($this->route['type']);
		}
		$libraryCriteria = Db_Criteria::create();//array('published' => 1)
		if($user->isInRole(Roles::CBS)){
			$libraryCriteria->add(Db_Exp::eq("cbs_sb_id", $user->cbs_id));
		}
		$libraries = $this->libraryDao->all($libraryCriteria->order('name asc'));
		$map = array();
		foreach($libraries as $l){
			$lids[] = $l->id;
			$map[$l->id] = $l;
		}
		$this->libraryMap = $map;
		$this->libraries = $libraries;
		$this->library = $library;
		$this->order = $order;
		$this->type = $type;
		$this->login = $login;
		
		$users = null;
		if($login){
			$sql = "select id from users where login like '%". mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $_GET['login']) . "%'";
			$userDao = new User_Dao();
			$users = $userDao->all(Db_Criteria::create()->sql($sql));
		}
		
		$limitSql = " limit " . ($page * $this->itemsPerPage) . ", " . $this->itemsPerPage;
		if($lids && ($login == null || $users)){
			$sql = "select o.*, title, isbn from order_items o inner join books b on o.book_id = b.id where o.library_id in (".join(',', $lids).")";
			if($library != null){
				$sql .= " and o.library_id = " . $library;
			}
			if($order != null){
				$sql .= " and order_id = " . $order;
			}
			if($type != null){
                if($type == "fund1"){ // old fund
                    $sql .= " and o.fund_type = 1";
                }
                if($type == "fund2"){ // exhange fund
                    $sql .= " and o.fund_type = 2";
                }
				if($type == "waiting"){
					$sql .= " and o.status = '". Order_Status::NEW_ORDER . "'";
				}
				if($type == "processed"){
					$sql .= " and o.status = '". Order_Status::READY . "'";
				}
				if($type == "taken"){
					$sql .= " and o.status = '". Order_Status::TAKEN . "'";
				}
				if($type == "absent"){
					$sql .= " and o.status ='". Order_Status::ABSENT . "'";
				}
				if($type == "refused"){
					$sql .= " and o.status ='". Order_Status::REFUSED . "'";
				}
			}
			if($users){
				$ids = array();
				foreach($users as $u){
					$ids[] = $u->id;
				}
				$sql .= " and user_id in (".join(',', $ids).")";
			}
			if($type == "waiting"){
				$sql .= " order by IFNULL(left_time_start, now() + interval 100 day)";
			}else{
				$sql .= " order by o.id desc";
			}
			$this->ordersCount = $this->dao->one(Db_Criteria::create()->sql(str_replace("o.*, title, isbn", "count(*) as c", $sql)))->c;

            /**
             * Counting overall orders
             */
            $orderItems = "select from order_items";
            if($user->isInRole(Roles::CBS)){
                $cbsCriteria = 'order_items.library_id in ('.join(',', $lids).')';
                $this->allCount = $this->dao->count(Db_Criteria::create([$cbsCriteria])->sql($orderItems));
                $this->fund1Count = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'fund_type = 1'])->sql($orderItems));
                $this->fund2Count = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'fund_type = 2'])->sql($orderItems));
                $this->waitCount = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'status = 0'])->sql($orderItems));
                $this->readyCount = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'status = 1'])->sql($orderItems));
                $this->takenCount = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'status = 3'])->sql($orderItems));
                $this->absentCount = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'status = 2'])->sql($orderItems));
                $this->refusedCount = $this->dao->count(Db_Criteria::create([$cbsCriteria, 'status = 4'])->sql($orderItems));
            } else {
                $this->allCount = $this->dao->count(Db_Criteria::create()->sql($orderItems));
                $this->fund1Count = $this->dao->count(Db_Criteria::create(['fund_type = 1'])->sql($orderItems));
                $this->fund2Count = $this->dao->count(Db_Criteria::create(['fund_type = 2'])->sql($orderItems));
                $this->waitCount = $this->dao->count(Db_Criteria::create(['status = 0'])->sql($orderItems));
                $this->readyCount = $this->dao->count(Db_Criteria::create(['status = 1'])->sql($orderItems));
                $this->takenCount = $this->dao->count(Db_Criteria::create(['status = 3'])->sql($orderItems));
                $this->absentCount = $this->dao->count(Db_Criteria::create(['status = 2'])->sql($orderItems));
                $this->refusedCount = $this->dao->count(Db_Criteria::create(['status = 4'])->sql($orderItems));
            }
            /**
             * Counting orders by status in selected library
             */
            if(isset($library)) {
                $this->aCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id])->sql($orderItems));
                $this->f1Count = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'fund_type = 1'])->sql($orderItems));
                $this->f2Count = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'fund_type = 2'])->sql($orderItems));
                $this->wCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'status = 0'])->sql($orderItems));
                $this->rCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'status = 1'])->sql($orderItems));
                $this->tCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'status = 3'])->sql($orderItems));
                $this->abCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'status = 2'])->sql($orderItems));
                $this->reCount = $this->dao->count(Db_Criteria::create(['library_id = ' . $library->id, 'status = 4'])->sql($orderItems));
            }

            $sql .= $limitSql;
			//echo '<!--'.$sql .'-->';
			$this->orders = $this->dao->all(Db_Criteria::create()->sql($sql));
		}else{
			$this->orders = array();
		}
		$pageUrl = "/order/index";
		if($library){
			$pageUrl .= "/library/".$library->id;
		}
		if($order){
			$pageUrl .= "/order/".$order;
		}
		if($type){
			$pageUrl .= "/type/".$type;
		}
		$this->pageUrl = $pageUrl;
		$this->view->itemsPerPage = $this->itemsPerPage;
		if($this->orders){
			$bookIds = array();
			foreach($this->orders as $order){
				$bookIds[] = $order->book_id;
			}
			$this->view->authors = Util::getAuthors($bookIds, $this->authorDao);
		}
	}
	
	public function export(){
		$this->output = false;

		$reportType = 'library';
		$reportStatus = 'new';

		$user = Auth_Auth::getUser();

		$library = null;
		$order = null;
		$login = null;
		if(isset($this->route['library'])){
			$library = $this->libraryDao->get(intval($this->route['library']));
		}
		if(isset($this->route['order'])){
			$order = intval($this->route['order']);
		}
		if(isset($_GET['login'])){
			$login = htmlentities($_GET['login']);
		}
		$type = null;
		if(isset($this->route['type'])){
			$type = htmlentities($this->route['type']);
		}

        if($library != null){
		    $library = $library->id;
        } else {
            $library = null;
        }

		$params = array(
		    'user_roles' => $user->roles,
		    'user_cbs_id' => $user->cbs_id,
		    'library_id' => $library,
            'order_type' => $type,
            'order_id' => $order,
            'login' => $login
        );
        $params = json_encode($params);

        $fileName = md5($user->login . time());

        $this->exportDao->sql("insert into exports values (null, '" .$fileName. "', '" .$user->id. "', '" .$params. "', '" .$reportType. "', '" .$reportStatus. "', null)");
	}

    public function report(){
        $this->output = false;

        $reportType = 'period';
        $reportStatus = 'new';

        $user = Auth_Auth::getUser();

        $from = strtotime($_POST['from']);
        $to = strtotime($_POST['to']) + 3600 * 24;

        $params = array(
            'time_from' => $from,
            'time_to' => $to,
        );
        $params = json_encode($params);

        $fileName = md5($user->login . time());

        $this->exportDao->sql("insert into exports values (null, '" .$fileName. "', '" .$user->id. "', '" .$params. "', '" .$reportType. "', '" .$reportStatus. "', null)");
    }

    public function extend()
    {
        $this->output = false;
        $order = $this->orderDao->get(intval($this->route['id']));
        $days = intval($this->route['days']);

        if ($order == null || $order->status != Order_Status::READY) {
            echo json_encode(array('status' => 'error'));
            return;
        }

        if (is_numeric($days)) {
            $this->orderDao->manualExtend($order, $days);
        } else {
            echo json_encode(array('status' => 'error'));
            return;
        }

        echo json_encode(array('status' => 'ok'));
    }

    public function found()
    {
        $this->output = false;
        $orderItem = $this->dao->get($this->route['id']);
        $orderItemBookId = $orderItem->book_id;

        if($orderItem == null){
            throw new PageNotFoundException();
        }
        if($orderItem->status != Order_Status::ABSENT){
            throw new PageNotFoundException();
        }

        $this->dao->update($orderItem->id, array('status' => Order_Status::FOUND, 'processed_at' => date("Y-m-d H:i:s")));
        $this->bookDao->update($orderItemBookId, array('status' => Book_Status::ACTIVE));

        /**
         * Logging Order Item status if book was ABSENT and become READY
         */
        $this->orderLogDao->insert(array('order_id' => $orderItem->order_id, 'book_id' => $orderItem->book_id, 'status_1' => Order_Status::ABSENT, 'status_2' => Order_Status::FOUND, 'created_at' => date("Y-m-d H:i:s")));
    }

	public static function registerInMenu()
	{
		return new Lib_MenuItem("Заказы", "/order", 4);
	}	
}
?>