<?php
class ReviewsController extends AdminController
{
	private $dao;
	
	private $libraryDao;

	private $exportDao;
	
	private $itemsPerPage = 50;
	
	public function __construct()
	{
		parent::__construct();
		$this->dao = new Review_Dao();
		$this->libraryDao = new Library_Dao();
		$this->exportDao = new Export_Dao();
		$this->title = $this->pageTitle = "Отзывы о библиотеках";
	}
	
	public function index()
	{
		$this->getReviews();
		$this->view->itemsPerPage = $this->itemsPerPage;
	}
	
	private function getReviews($export = false){
		$page = $this->parsePage();
		$this->page = $page + 1;
		
		$user = Auth_Auth::getUser();
		$libraryCriteria = Db_Criteria::create(array('published' => 1));
		if($user->isInRole(Roles::CBS)){
			$libraryCriteria->add(Db_Exp::eq("cbs_sb_id", $user->cbs_id));
		}
		$this->libraries = $libraries = $this->libraryDao->all($libraryCriteria->order('name asc'));
		
		$library = null;
		if(isset($this->route['library'])){
			$library = $this->libraryDao->get(intval($this->route['library']));
		}
		$criteria = Db_Criteria::create()->add(Db_Exp::gt('value', 0));
		if($library != null){
			$criteria->add(Db_Exp::eq('library_id', $library->id));
		}
		
		if($user->isInRole(Roles::CBS)){
			$ids = array();
			foreach($libraries as $l){
				$ids[] = $l->id;
			}
			$criteria->add(Db_Exp::in('library_id', $ids));
		}
		$criteria->order('id desc');
		if(!$export){
			$criteria->perPage($this->itemsPerPage)->page($page);
		}
		$this->reviews = $this->dao->all($criteria);
		$this->library = $library;
		
		$pageUrl = "/reviews/index";
		if($library){
			$pageUrl .= "/library/".$library->id;
		}
		$this->pageUrl = $pageUrl;
	}

    public function export(){
        $this->output = false;

        $reportType = 'reviews';
        $reportStatus = 'new';

        $user = Auth_Auth::getUser();

        $library = null;
        if(isset($this->route['library'])){
            $library = $this->libraryDao->get(intval($this->route['library']));
        }

        $params = array(
            'user_roles' => $user->roles,
            'user_cbs_id' => $user->cbs_id,
            'library_id' => $library->id,
        );
        $params = json_encode($params);

        $fileName = md5($user->login . time());

        $this->exportDao->sql("insert into exports values (null, '" .$fileName. "', '" .$user->id. "', '" .$params. "', '" .$reportType. "', '" .$reportStatus. "', null)");
    }

	public function delete()
	{
		$this->dao->delete($this->route['id']);
		$this->output = false;
	}
	
	public static  function registerInMenu()
	{
		return new Lib_MenuItem("Отзывы", "/reviews", 4);
	}
	
}
?>