<?php

class UsersController extends AdminController
{
    private $dao;

    private $itemDao;

    private $exportDao;

    private $itemsPerPage = 50;

    public function __construct()
    {
        parent::__construct();
        $this->dao = new User_Dao();
        $this->itemDao = new Order_Item_Dao();
        $this->exportDao = new Export_Dao();
        $this->title = $this->pageTitle = "Управление пользователями";
    }

    public function export()
    {
        $reportType = 'users';
        $reportStatus = 'new';

        $user = Auth_Auth::getUser();

        $user_type = null;
        if (isset($this->route['type'])) {
            $type = $this->route['type'];
            if ($type == 'registered') {
                $user_type = 'registered';
            }
            if ($type == 'directory') {
                $user_type = 'directory';
            }
            if ($type == 'lrentity') {
                $user_type = 'lrentity';
            }
            if ($type == 'requentity') {
                $user_type = 'requentity';
            }
            if ($type == 'entity') {
                $user_type = 'entity';
            }
            if ($type == 'generic') {
                $user_type = 'generic';
            }
            if ($type == 'library') {
                $user_type = 'library';
            }
            if ($type == 'cbs') {
                $user_type = 'cbs';
            }
        }

        $params = array(
            'user_type' => $user_type,
        );
        $params = json_encode($params);

        $fileName = md5($user->login . time());

        $this->exportDao->sql("insert into exports values (null, '" . $fileName . "', '" . $user->id . "', '" . $params . "', '" . $reportType . "', '" . $reportStatus . "', null)");
    }

    public function index()
    {
        $page = $this->parsePage();
        $this->page = $page + 1;
        $sql = "select u.* from " . DB_PREFIX . "users u where ";
        $cr = "true = true";
        if (isset($_GET['login'])) {
            $login = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $_GET['login']);
            $cr .= " and login like '%" . $login . "%'";
            $this->login = $login;
        }
        if (isset($_GET['library'])) {
            $cr .= " and library_id = " . intval($_GET['library']);
            $libraryDao = new Library_Dao();
            $this->library = $libraryDao->get(intval($_GET['library']));
        }
        if (isset($_GET['cbs'])) {
            $cr .= " and cbs_id = " . intval($_GET['cbs']);
        }
        if (isset($this->route['type'])) {
            $type = $this->route['type'];
            if ($type == 'registered') {
                $cr .= " and roles like '%" . Roles::USER . "%' and roles not like '%" . Roles::MODERATOR . "%' and roles not like '%" . Roles::ADMIN . "%'";
            }
            if ($type == 'directory') {
                $cr .= " and (roles like '%" . Roles::MODERATOR . "%' || roles like '%" . Roles::ADMIN . "%' and roles not like '%" . Roles::LRENTITY . "%' and roles not like '%" . Roles::ENTITY . "%') and cbs_id is null and library_id is null";
            }
            if ($type == 'requentity') {
                $cr .= " and roles like '%" . Roles::LRENTITY . "%' and isblocked = 1";
            }
            if ($type == 'lrentity') {
                $cr .= " and roles like '%" . Roles::LRENTITY . "%' and isblocked = 0 and library_id is null";
            }
            if ($type == 'entity') {
                $cr .= " and roles like '%" . Roles::ENTITY . "%'";
            }
            if ($type == 'generic') {
                $cr .= " and login like 'generic%'";
            }
            if ($type == 'library') {
                $cr .= " and library_id is not null";
            }
            if ($type == 'cbs') {
                $cr .= " and cbs_id is not null";
            }
            $this->view->type = $type;
        }
        $libraryDao = new Library_Dao();
        $this->libraries = $libraryDao->all(Db_Criteria::create()->order('name asc'));
        $this->count = $this->dao->count(Db_Criteria::create()->add(Db_Exp::sql($cr)));
        $sql .= $cr;
        $sql .= " order by id desc limit " . ($page * $this->itemsPerPage) . ", $this->itemsPerPage";
        $this->users = $this->dao->all(Db_Criteria::create()->sql($sql));
        $this->pageUrl = "/users/index";
        if ($this->view->type) {
            $this->pageUrl = "/users/index/type/" . $this->view->type;
        }
        $this->view->itemsPerPage = $this->itemsPerPage;
    }

    public function edit()
    {
        $user = $this->dao->get($this->route['id']);
        if ($user->isInRole(Roles::LIBRARY)) {
            $libraryDao = new Library_Dao();
            $this->libraries = $libraryDao->all(Db_Criteria::create()->order('name asc'));
        }

        if ($user->isInRole(Roles::CBS)) {
            $cbsDao = new Cbs_Dao();
            $this->cbss = $cbsDao->all(Db_Criteria::create()->order('name asc'));
        }

        $this->user = $user;
        $this->registerButton(new Lib_Button("save", "", 'Сохранить'));
    }

    public function view()
    {
        $user = $this->dao->get($this->route['id']);
        if ($user->isInRole(Roles::LIBRARY)) {
            $libraryDao = new Library_Dao();
            $this->libraries = $libraryDao->all(Db_Criteria::create()->order('name asc'));
        }

        if ($user->isInRole(Roles::CBS)) {
            $cbsDao = new Cbs_Dao();
            $this->cbss = $cbsDao->all(Db_Criteria::create()->order('name asc'));
        }

        $this->user = $user;
        /**
         * User stats
         */
        //$this->ordersCount = $this->itemDao->count(Db_Criteria::create(['user_id = ' . $user->id]));
        $this->takenCount = $this->itemDao->count(Db_Criteria::create(['user_id = ' . $user->id, 'status = 3']));
        $this->bookedCount = $this->itemDao->count(Db_Criteria::create(['user_id = ' . $user->id, 'status = 1']));
        $this->refusedCount = $this->itemDao->count(Db_Criteria::create(['user_id = ' . $user->id, 'status = 4']));
        $this->expiredCount = $this->itemDao->count(Db_Criteria::create(['user_id = ' . $user->id, 'status = 5']));
    }

    public function resendreg()
    {
        $this->output = false;
        $user = $this->dao->get(intval($this->route['id']));
        if ($user != null) {
            $this->dao->resetRegistrationEmail($user);
        }
    }

    public function form($data)
    {
        $user = $this->dao->get($data['id']);
        if ($user->email != $data['email'] && !$this->checkEMail($data)) {
            $this->addFormError("email", "not.unique");
            return;
        }
        $userData = array('email' => $data['email'], 'isblocked' => $data['isblocked'], 'roles' => $data['roles'], 'name' => $data['name']);
        if ($user->login != 'admin') {
            $userData['login'] = $data['email'];
        }
        if ($data['password'] != '')
            $userData['password'] = md5(trim($data['password']));
        $user->roles = $data['roles'];
        foreach (array('phone', 'birth_date', 'gender', 'reader', 'inn', 'ogrn', 'org_name', 'org', 'legal_address', 'head', 'position', 'executive') as $f) {
            if (isset($data[$f])) {
                $userData[$f] = $data[$f];
            }
        }
        if ($user->isInRole(Roles::LIBRARY)) {
            $userData['library_id'] = $data['library_id'];
        } else {
            $userData['library_id'] = null;
        }
        if ($user->isInRole(Roles::CBS)) {
            $userData['cbs_id'] = $data['cbs_id'];
        } else {
            $userData['cbs_id'] = null;
        }
        $this->dao->update($data['id'], $userData);
    }

    public function delete()
    {
        $this->dao->delete($this->route['id']);
        $this->output = false;
    }

    public function publish()
    {
        $id = $this->route['id'];
        $user = $this->dao->get($id);
        $this->output = false;
        $this->dao->update($id, array('isblocked' => 1 - $user->isblocked));
        if ($user->library_id) {
            $library = $user->library;
            if ($library != null) {
                $libraryDao = new Library_Dao();
                $libraryDao->update($library->id, array('published' => $user->isblocked));

                $bookDao = new Book_Dao();
                $bookDao->updateByCriteria(Db_Criteria::create(array('library_id' => $library->id)), array('published' => $user->isblocked));
            }
        }
    }

    private function checkEmail($data)
    {
        return $this->dao->getByEmail($data['email']) == null;
    }

    public static function registerInMenu()
    {
        return new Lib_MenuItem("Пользователи", "/users", 3);
    }

    public function decline()
    {
        $this->output = false;
        $user = $this->dao->get(intval($this->route['id']));
        $message = $_POST['decline'];
        if ($user != null) {
            $this->dao->declineUser($user, addslashes($message));
        }
    }

    public function approve()
    {
        $this->output = false;
        $user = $this->dao->get(intval($this->route['id']));
        if ($user != null) {
            $this->dao->approveUser($user);
        }
    }

}

?>