AjaxForm.options.prefix = '/admin';

var timeoutHandler;

function showOk(data){
	jq(".ok-panel").show(200, function(){
		clearTimeout(timeoutHandler);
		timeoutHandler = setTimeout(function(){
			if(data && data.data.id)
				document.location.href = window.baseUrl + data.data.id;
			else
				jq(".ok-panel").hide();
		}, 1000);
	});
}

onInit(function(){
	var sel = jq(".top1 select");
	if(sel.length == 0)
		return;
	sel.change(function(){
		jq.get("/admin/language/?lang=" + sel.val(), function(){
			document.location.href = document.location.href;
		});
	});
});

TreeMenu = {
	data:{},
	init: function(id){
		if(TreeMenu.data[id] != undefined)
			return TreeMenu.data[id];
		var o = {};
		o.container = jq("#item" + id);
		var pl = jq("#plus" + id);
		if(pl.length > 0){
			o.plus = jq("img[src*=plus]", pl);
			o.minus = jq("img[src*=minus]", pl);
		}
		var buttons = jq(".buttons", o.container).eq(0);
		o.publ = jq(".publ", buttons);
		o.unpubl = jq(".unpubl", buttons);
		o.del = jq(".del", buttons);
		o.down = jq(".down", buttons);
		o.up = jq(".up", buttons);
		o.ord = jq(".count", buttons);
		o.sub = jq("#sub" + id);
		TreeMenu.data[id] = o;
		return TreeMenu.data[id];
	},
	pub: function(id, url){
		var d = TreeMenu.init(id);
		jq.get(url + "/id/" + id  + "/?empty=1", function(){
			d.publ.toggle();
			d.unpubl.toggle();
		});
		return false;
	},
	del: function(id, url){
		var d = TreeMenu.init(id);
		if(!confirm("Вы действительно хотите удалить?"))
			return;
		if(d.sub.length > 0)
			d.sub.remove();
		d.container.remove();
		jq.get(url + "/id/" + id  + "/?empty=1");
	},
	sub: function(id){
		var d = TreeMenu.init(id);
		d.minus.toggle();
		d.plus.toggle();
		d.sub.toggle();
	},
	up:function(id, url){TreeMenu.setOrder(id, -1, url);},
	down:function(id, url){TreeMenu.setOrder(id, 1, url);},
	setOrder:function(id, dif, url){
		var d = TreeMenu.init(id);
		var order = parseInt(d.ord.html());
		var newV = order + dif;
		if(newV < 0)
			return;
		jq.get(url + "/id/" + id + "/ord/" + newV  + "/?empty=1", function(){
			d.ord.html("" + newV);
		});
	}
}

List = {
	data:{},
	init: function(id){
		if(List.data[id] != undefined)
			return List.data[id];
		var o = {};
		o.container = jq("#list_item" + id);
		o.del = jq(".del", o.container);
		o.publ = jq(".publ", o.container);
		o.unpubl = jq(".unpubl", o.container);
		List.data[id] = o;
		return List.data[id];
	},
	del: function(id, url){
		var d = List.init(id);
		if(!confirm("Вы действительно хотите удалить?"))
			return;
		jq.get(url + "/id/" + id  + "/?empty=1", function(){
			d.container.remove();
		});
	},
    entap: function(id, url){
        var d = List.init(id);
        jq.get(url + "/id/" + id  + "/?empty=1", function(){
            d.container.remove();
        });
    },
    entdec: function(id, url){
        var d = List.init(id);
        var decline = prompt('Введите причину отказа');
        decline && jq.post(url + "/id/" + id, {decline:decline}, function(){
			d.container.remove();
		});
    },
	delFile: function(id, file, url){
		var d = List.init(id);
		if(!confirm("Вы действительно хотите удалить?"))
			return;
		jq.post(url, {file:file}, function(){
			d.container.remove();
		});
	},
	pub: function(id, url){
		var d = List.init(id);
		jq.get(url + "/id/" + id  + "/?empty=1", function(){
			d.publ.toggle();
			d.unpubl.toggle();
		});
		return false;
	},
    resend: function(id, url){
        var d = List.init(id);
        jq.get(url + "/id/" + id  + "/?empty=1", function(){
            alert("Письмо повторно отправлено!");
        });
    },
    extend: function(id, url){
        var days = prompt("На сколько дней продлить бронь заказа № " + id + "?");
        if(isNaN(days)) {
        	alert('Вы ввели не числовое значение!')
			return;
		}
        days && jq.get(url + "/id/" + id  + "/days/" + days, function(){
            alert("Вы продлили время окончания брони заказа " + id + "!");
        });
    },
	found: function(id, url){
        var d = List.init(id);
        if(!confirm("Пожалуйста, подтвердите действие!"))
            return;
        jq.get(url + "/id/" + id, function(){
            d.container.remove();
        });
	}
};

function getUrl(){
	var url = jq.trim(this.control.val());
	if(url.length < 1)
		return url;
//	if(url.charAt(0) == '/')
//		url = url.substr(1, url.length);
	return url;
}

try{
jq.extend(DateInput.DEFAULT_OPTS, {
  stringToDate: function(string) {
    var matches;
    if (matches = string.match(/^(\d{2,2})-(\d{2,2})-(\d{4,4})$/)) {
      return new Date(matches[3], matches[2] - 1, matches[1]);
    } else {
      return null;
    };
  },

  dateToString: function(date) {
    var month = (date.getMonth() + 1).toString();
    var dom = date.getDate().toString();
    if (month.length == 1) month = "0" + month;
    if (dom.length == 1) dom = "0" + dom;
    return dom + "-" + month + "-" + date.getFullYear();
  }
});
}catch(e){};

function send_email(el, id){
	jq.post("/admin/faq/mail", {id:id}, function(){
		jq(el).parent().html("Письмо отправлено");
	});
}

var Image = {
	initUploader: function(){
		var subSo = new SWFObject("/admin/flash/uploader.swf", "sub_gallery_uploader", "250", "25", "9");
		subSo.addParam("wmode", "opaque");
		subSo.addVariable("url", "/admin/photo/upload?atmsessid=" + window.sessionid);
		subSo.addVariable("dataid", 0);
		subSo.addVariable("onError", "Image.error");
		subSo.addVariable("onUpload", "Image.upload");
		subSo.addVariable("multi", "true");
		subSo.write("sub_gallery");
	},
	error: function(error){
		alert("Произошла ошибка при загрузке файла");
	},
	upload: function(data){
		var gallery = jq("#sub_gallery_photos");
		data = jq.evalJSON(data);
		gallery.append("<div id='" + data.id + "'><img src='/uploads/images/admin" + data.image.id + ".jpg'/><a href='#' class='del-photo' onclick='Image.del(this);return false;'><img src='/admin/images/publish_x.png' class='png' /></a></div>");
	},
	del: function(el){
		jq(el).parent().remove();
	},
	ids: function(container){
		return jq("#" + container).sortable("toArray").join(',');
	}
};

function checkFile(file){
	jq.post("/admin/file/check", {file: file}, function(){
		alert("Результаты будут отправлены на почту");
	});
}

var ServiceFilters = {
	add: function(){
		jq(".filters").append(jq("#empty-block").html());
	},
	remove: function(el){
		jq(el).parent().remove();
	},
	value: function(){
		var items = [];
		jq(".filters .filter-block").each(function(i, item){
			item = jq(item);
			var name = jq("input", item).val();
			if(name == "")
				return;
			if(item.data("id"))
				items.push({id: item.data("id"), name: name});
			else
				items.push({name: name});
		});
		if(items.length > 0)
			return JSON.stringify(items);
		return null;
	}
};

var Books = {
	upfund: function(){
		$.post('/admin/books/upfund', function(){
			alert('Книги перемещены!');
		});
	}
};

var Order = {
	ready: function(id){
		$.post("/admin/order/ready", {id: id}, function(){
			document.location.href = document.location.href;
		});
	},
	taken: function(id){
		$.post("/admin/order/taken", {id: id}, function(){
			document.location.href = document.location.href;
		});
	},
	refused: function(id){
		$.post("/admin/order/refused", {id: id}, function(){
			document.location.href = document.location.href;
		});
	},
	showAbsent: function(el){
		$(el).parent().find(".comment").show();
	},
	absent: function(el, id){
		var comment = $.trim($(el).parent().find("textarea").val());
		if(!comment){
			alert($(el).parent().find("i").text());
			return;
		}
		$.post("/admin/order/absent", {id: id, comment: comment}, function(){
			document.location.href = document.location.href;
		});
	},
	extend: function(el){
		$.post('/admin/order/extend', {days: $(el).prev().val()}, function(){
			alert('Готово');
		});
	},
    export: function(url){
        $.post(url, function(){
            alert('Задача помещена в очередь');
        });
    }
};

var Review = {
    export: function(url){
        $.post(url, function(){
            alert('Задача помещена в очередь');
        });
    }
};

var User = {
    export: function(url){
        $.post(url, function(){
            alert('Задача помещена в очередь');
        });
    }
};

var Forms = {
	getBack: function(){
		if(document.referrer){
			document.location.href = document.referrer;
		}else{
			document.location.href = this.annotations.successUrl;
		}
	}
};