<?php
class Lib_App extends App
{
	protected function processOutput()
	{
		$menu = array();
		foreach($config = Config::getInstance()->menu as $item)
		{
			if(!self::checkAccess($item))
				continue;
			$cl = ucfirst($item);
			if(!file_exists('controller/'.$cl.'Controller.php'))
				continue;
			$result = call_user_func(array($cl.'Controller', 'registerInMenu'));
			if($result)
				$menu[] = $result;
		}
		usort($menu, array("self", "sortMenu"));
		View_View::getInstance()->menu = $menu;
	}
	
	public static function checkAccess($route)
	{
		if(!is_string($route))
			$url = $route['controller'];
		else
			$url = $route;
		$u = Auth_Auth::getUser();
		if(!$u || $u->isSuperAdmin())
			return true;
		$a = Config::getInstance()->access;
		$access = array();
		if(isset($a[$url]))
			$access = $a[$url];
		foreach($access as $r)
			if($u->isInRole($r))
				return true;
		return false;
	}
	
	public static function sortMenu($n, $m)
	{
		if($n->order >= $m->order)
			return 1;
		return 0;
	}
}
?>