<?php
define('SITE_DIR', realpath(str_replace(basename(__FILE__), "", __FILE__) . "../../") . '/');

require_once SITE_DIR . 'atm/Loader.php';
Loader::addToPath(array(SITE_DIR . 'atm', SITE_DIR . '/lib', SITE_DIR . '/lib/dao', SITE_DIR . '/atm/dao', SITE_DIR . '/atm/view'));

$admin_zone = false;
require_once SITE_DIR . 'confs/conf.php';
require_once SITE_DIR . 'confs/db.php';
mb_internal_encoding('UTF-8');

$db = new Db_Mysql_Adapter();
Db_Dao::$db = $db;

$exportDao = new Export_Dao();
$itemDao = new Order_Item_Dao();
$bookDao = new Book_Dao();
$categoryDao = new Book_Category_Dao();
$libraryDao = new Library_Dao();
$authorDao = new Author_Dao();
$reviewDao = new Review_Dao();
$userDao = new User_Dao();

/**
 * Checking if no process is running
 */
$checkProcess = $exportDao->all(Db_Criteria::create(array('status' => 'process')));
if ($checkProcess) {
    die("process is running");
}

/**
 * Taking one record from DB to generate report file
 */
$newReport = $exportDao->one(Db_Criteria::create(array('status' => 'new')));

/**
 * Выгрузка заказов в XLS
 */
function makeExport($newReport, $exportDao, $itemDao, $libraryDao, $authorDao, $categoryDao)
{
    $exportDao->update($newReport->id, array('status' => 'process'));

    $fileName = $newReport->hash;
    $userId = $newReport->user_id;

    if (!file_exists(SITE_DIR . '/uploads/exports/' . $userId . '/')) {
        mkdir(SITE_DIR . '/uploads/exports/' . $userId . '/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/exports/' . $userId . '/' . $fileName . '.xls', 'w');

    $params = json_decode($newReport->params);
    $user_roles = $params->user_roles;
    $user_cbs_id = $params->user_cbs_id;
    $library = $params->library_id;
    $order = $params->order_id;
    $type = $params->order_type;
    $login = $params->login;

    $lids = array();

    $libraryCriteria = Db_Criteria::create();//array('published' => 1)
    if (in_array("5", $user_roles)) {
        $libraryCriteria->add(Db_Exp::eq("cbs_sb_id", $user_cbs_id));
    }

    $libraries = $libraryDao->all($libraryCriteria->order('name asc'));
    $map = array();
    foreach ($libraries as $l) {
        $lids[] = $l->id;
        $map[$l->id] = $l;
    }
    $view = View_View::getInstance();
    $view->exportUserData = !in_array("5", $user_roles);
    $view->libraryMap = $map;
    $view->libraries = $libraries;
    $view->library = $library;
    $view->order = $order;
    $view->type = $type;
    $view->login = $login;

    $users = null;
    if ($login) {
        $sql = "select id from users where login like '%" . $login . "%'";
        $userDao = new User_Dao();
        $users = $userDao->all(Db_Criteria::create()->sql($sql));
    }

    fwrite($f, $view->renderExportFile('layouts/export/orders/header'));

    if ($lids && ($login == null || $users)) {
        $sql = "select o.*, title, isbn from order_items o inner join books b on o.book_id = b.id where o.library_id in (" . join(',', $lids) . ")";
        if ($library != null) {
            $sql .= " and o.library_id = " . $library;
        }
        if ($order != null) {
            $sql .= " and order_id = " . $order;
        }
        if ($type != null) {
            if ($type == "fund1") {
                $sql .= " and o.fund_type = 1";
            }
            if ($type == "fund2") {
                $sql .= " and o.fund_type = 2";
            }
            if ($type == "waiting") {
                $sql .= " and o.status = '" . Order_Status::NEW_ORDER . "'";
            }
            if ($type == "processed") {
                $sql .= " and o.status = '" . Order_Status::READY . "'";
            }
            if ($type == "taken") {
                $sql .= " and o.status = '" . Order_Status::TAKEN . "'";
            }
            if ($type == "refused") {
                $sql .= " and o.status ='" . Order_Status::REFUSED . "'";
            }
            if ($type == "absent") {
                $sql .= " and o.status ='" . Order_Status::ABSENT . "'";
            }
        }
        if ($users) {
            $ids = array();
            foreach ($users as $u) {
                $ids[] = $u->id;
            }
            $sql .= " and user_id in (" . join(',', $ids) . ")";
        }
        if ($type == "waiting") {
            $sql .= " order by IFNULL(left_time_start, now() + interval 100 day)";
        } else {
            $sql .= " order by o.id desc";
        }
        $baseSql = $sql;
        $page = 0;
        $perPage = 50;
        do {
            $sql = $baseSql . " limit " . ($page * $perPage) . ", " . $perPage;
            $view->orders = $itemDao->all(Db_Criteria::create()->sql($sql));

            if ($view->orders) {
                $bookIds = array();
                foreach ($view->orders as $order) {
                    $bookIds[] = $order->book_id;
                }
                $view->authors = Util::getAuthors($bookIds, $authorDao);
                $view->categories = Util::getCategories($bookIds, $categoryDao);
            }

            fwrite($f, $view->renderExportFile('layouts/export/orders/items'));
            $page++;
        } while ($view->orders);

    } else {
        $view->orders = array();
    }

    fwrite($f, $view->renderExportFile('layouts/export/orders/footer'));
    fclose($f);

    /**
     * Changing status of current record from DB to complete
     */
    $exportDao->update($newReport->id, array('status' => 'done'));
}

/**
 * Выгрузка отчета за период в XLS
 */
function makeReport($newReport, $exportDao, $itemDao, $libraryDao)
{
    $exportDao->update($newReport->id, array('status' => 'process'));

    $fileName = $newReport->hash;
    $userId = $newReport->user_id;

    if (!file_exists(SITE_DIR . '/uploads/exports/' . $userId . '/')) {
        mkdir(SITE_DIR . '/uploads/exports/' . $userId . '/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/exports/' . $userId . '/' . $fileName . '.xls', 'w');

    $params = json_decode($newReport->params);
    $from = $params->time_from;
    $to = $params->time_to;

    $view = View_View::getInstance();
    $view->cbsDao = new Cbs_Dao();
    $view->libraryDao = $libraryDao;

    $dates = array();
    for ($d = $from; $d < $to; $d += 3600 * 24) {
        $dates[] = date("d.m.Y", $d);
    }
    $criteria = Db_Criteria::create();
    $criteria->add(Db_Exp::ge('date', date('Y-m-d', $from)));
    $criteria->add(Db_Exp::lt('date', date('Y-m-d', $to)));
    $criteria->order('date asc');

    $result = array();
    $page = 0;
    do {
        $items = $itemDao->all($criteria->page($page)->perPage(100));
        $page++;
        foreach ($items as $item) {
            $library = $item->library;
            if (!isset($result[$library->cbs_sb_id])) {
                $result[$library->cbs_sb_id] = array();
            }
            if (!isset($result[$library->cbs_sb_id][$library->id])) {
                $result[$library->cbs_sb_id][$library->id] = array();
            }
            $line = $result[$library->cbs_sb_id][$library->id];
            $date = date('d.m.Y', strtotime($item->date));
            if (!isset($line[$date])) {
                $line[$date] = array('books' => 0, 'ready_books' => 0, 'absent_books' => 0, 'taken_books' => 0, 'refused_books' => 0, 'processed_at_time' => 0, 'processed_out_of_time' => 0);
            }
            $gap = $line[$date];
            $gap['books']++;
            if ($item->status != Order_Status::ABSENT && $item->status != Order_Status::NEW_ORDER) {
                $gap['ready_books']++;
            }
            if ($item->status == Order_Status::ABSENT) {
                $gap['absent_books']++;
            }
            if ($item->status == Order_Status::TAKEN) {
                $gap['taken_books']++;
            }
            if ($item->status == Order_Status::REFUSED) {
                $gap['refused_books']++;
            }
            if ($item->processed_at) {
                $minutes = ceil((strtotime($item->processed_at) - strtotime($item->date)) / 60);
                if ($minutes > 30) {
                    $gap['processed_out_of_time']++;
                } else {
                    $gap['processed_at_time']++;
                }
            }
            $line[$date] = $gap;
            $result[$library->cbs_sb_id][$library->id] = $line;
        }
    } while ($items);
    $view->dates = $dates;
    $view->result = $result;

    fwrite($f, $view->renderExportFile('layouts/report'));
    fclose($f);

    /**
     * Changing status of current record from DB to complete
     */
    $exportDao->update($newReport->id, array('status' => 'done'));
}

/**
 * Выгрузка отзывов в XLS
 */
function makeReviews($newReport, $exportDao, $reviewDao, $libraryDao)
{
    $exportDao->update($newReport->id, array('status' => 'process'));

    $fileName = $newReport->hash;
    $userId = $newReport->user_id;

    if (!file_exists(SITE_DIR . '/uploads/exports/' . $userId . '/')) {
        mkdir(SITE_DIR . '/uploads/exports/' . $userId . '/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/exports/' . $userId . '/' . $fileName . '.xls', 'w');

    $params = json_decode($newReport->params);
    $user_roles = $params->user_roles;
    $user_cbs_id = $params->user_cbs_id;
    $library = $params->library_id;

    $view = View_View::getInstance();

    $libraryCriteria = Db_Criteria::create(array('published' => 1));
    if (in_array("5", $user_roles)) {
        $libraryCriteria->add(Db_Exp::eq("cbs_sb_id", $user_cbs_id));
    }

    $libraries = $libraryDao->all($libraryCriteria->order('name asc'));

    $criteria = Db_Criteria::create()->add(Db_Exp::gt('value', 0));
    if ($library != null) {
        $criteria->add(Db_Exp::eq('library_id', $library));
    }

    if (in_array("5", $user_roles)) {
        $ids = array();
        foreach ($libraries as $l) {
            $ids[] = $l->id;
        }
        $criteria->add(Db_Exp::in('library_id', $ids));
    }
    $criteria->order('id desc');

    $reviews = $reviewDao->all($criteria);
    $view->reviews = $reviews;

    fwrite($f, $view->renderExportFile('layouts/export/reviews'));
    fclose($f);

    /**
     * Changing status of current record from DB to complete
     */
    $exportDao->update($newReport->id, array('status' => 'done'));
}

/**
 * Выгрузка пользователей в XLS
 */
function makeUsers($newReport, $exportDao, $userDao)
{
    $exportDao->update($newReport->id, array('status' => 'process'));

    $fileName = $newReport->hash;
    $userId = $newReport->user_id;

    if (!file_exists(SITE_DIR . '/uploads/exports/' . $userId . '/')) {
        mkdir(SITE_DIR . '/uploads/exports/' . $userId . '/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/exports/' . $userId . '/' . $fileName . '.xls', 'w');

    $params = json_decode($newReport->params);
    $user_type = $params->user_type;

    $view = View_View::getInstance();

    $sql = "select u.*, count(o.id) as active from " . DB_PREFIX . "users u left join orders o on u.id = o.user_id where 1";
    if ($user_type != null) {
        $type = $user_type;
        if ($type == 'registered') {
            $sql .= " and roles like '%" . Roles::USER . "%' and roles not like '%" . Roles::MODERATOR . "%' and roles not like '%" . Roles::ADMIN . "%'";
        }
        if ($type == 'directory') {
            $sql .= " and (roles like '%" . Roles::MODERATOR . "%' || roles like '%" . Roles::ADMIN . "%' and roles not like '%" . Roles::LRENTITY . "%' and roles not like '%" . Roles::ENTITY . "%') and cbs_id is null and library_id is null";
        }
        if ($type == 'requentity') {
            $sql .= " and roles like '%" . Roles::LRENTITY . "%' and isblocked = 1";
        }
        if ($type == 'lrentity') {
            $sql .= " and roles like '%" . Roles::LRENTITY . "%' and isblocked = 0 and library_id is null";
        }
        if ($type == 'entity') {
            $sql .= " and roles like '%" . Roles::ENTITY . "%'";
        }
        if ($type == 'generic') {
            $sql .= " and login like 'generic%'";
        }
        if ($type == 'library') {
            $sql .= " and library_id is not null";
        }
        if ($type == 'cbs') {
            $sql .= " and cbs_id is not null";
        }
    }
    $sql .= " group by u.id order by id desc";

    $users = $userDao->all(Db_Criteria::create()->sql($sql));

    $view->users = $users;

    fwrite($f, $view->renderExportFile('layouts/export/users'));
    fclose($f);

    /**
     * Changing status of current record from DB to complete
     */
    $exportDao->update($newReport->id, array('status' => 'done'));
}

/**
 * Выгрузка остатка по фондам в XLS
 */
function makeBooksLeft($newReport, $exportDao, $bookDao, $authorDao)
{
    $exportDao->update($newReport->id, array('status' => 'process'));

    $fileName = $newReport->hash;
    $userId = $newReport->user_id;

    if (!file_exists(SITE_DIR . '/uploads/exports/' . $userId . '/')) {
        mkdir(SITE_DIR . '/uploads/exports/' . $userId . '/', 0777, true);
    }
    $f = fopen(SITE_DIR . '/uploads/exports/' . $userId . '/' . $fileName . '.xls', 'w');

    $params = json_decode($newReport->params);
    $fund_type = $params->fund_type;

    $view = View_View::getInstance();

    $sql = "select b.*, l.name, l.address, l.cbs_sb_id, c.name as cbs_name from " . DB_PREFIX . "books b join libraries l on b.library_id = l.id join cbs_sb c on l.cbs_sb_id = c.id where b.status = 0";
    if ($fund_type == '1') {
        $sql .= " and b.fund_type = 1";
    }
    if ($fund_type == '2') {
        $sql .= " and b.fund_type = 2";
    }

    $booksLeft = $bookDao->all(Db_Criteria::create()->sql($sql));

    $bookIds = array();
    foreach ($booksLeft as $i => $book) {
        $bookIds[] = (int)$book->id;
    }

    $authors = Util::getAuthors($bookIds, $authorDao);

    foreach ($booksLeft as $i => $book) {
        $book->author = $authors[$book->id][0]->name ?: '-';
    }

    $view->booksLeft = $booksLeft;

    fwrite($f, $view->renderExportFile('layouts/export/booksleft'));
    fclose($f);

    /**
     * Changing status of current record from DB to complete
     */
    $exportDao->update($newReport->id, array('status' => 'done'));
}

function foo($newReport, $exportDao, $itemDao, $libraryDao, $reviewDao, $userDao, $authorDao, $categoryDao, $bookDao)
{
    if (!isset($newReport) && !$newReport) {
        die('empty');
    }
    if ($newReport->type == 'library') {
        makeExport($newReport, $exportDao, $itemDao, $libraryDao, $authorDao, $categoryDao);
    } elseif ($newReport->type == 'period') {
        makeReport($newReport, $exportDao, $itemDao, $libraryDao);
    } elseif ($newReport->type == 'reviews') {
        makeReviews($newReport, $exportDao, $reviewDao, $libraryDao);
    } elseif ($newReport->type == 'users') {
        makeUsers($newReport, $exportDao, $userDao);
    } elseif ($newReport->type == 'booksleft') {
        makeBooksLeft($newReport, $exportDao, $bookDao, $authorDao);
    } else {
        throw new Error();
    }
}

try {
    foo($newReport, $exportDao, $itemDao, $libraryDao, $reviewDao, $userDao, $authorDao, $categoryDao, $bookDao);
} catch (Error $e) {
    $exportDao->update($newReport->id, array('status' => 'error'));
}

?>