var Finch = Finch || {};

Finch.AjaxForm = Finch.Class.create({
	initialize: function(el){
		this.container = el;
		this.errorContainer = null;
		this.fields = {};
		this.valid = true;
		this.annotations = {};
		this.isSubmitting = false;
		this.submit_button = $("input:submit,input:image, .submit, button:submit", el);
		if(this.submit_button.length > 0)
			this.submit_button.click(Finch.Func.bind(this.submitForm, this));
		this.parseFields();
		this.progress = $(".progress", el);
	},
	getId: function(){
		return this.id;
	},
	getFormError: function(error){
		var camelError = this.convertSnakeToCameCase(error);
		if(this.annotations[camelError]){
			return this.annotations[camelError];
		}
		if(this.annotations[error]){
			return this.annotations[error];
		}
		return null;
	},
	setFormError: function(error, exact){
		if(this.annotations.hideSubmit){
			this.submit_button.show();
		}
		if(exact && this.errorContainer){
			this.errorContainer.show().html(error);
			return;
		}
		var camelError = this.convertSnakeToCameCase(error);
		if(this.errorContainer){
			var e = this.getFormError(error);
			if(e){
				this.errorContainer.show().html(e);
			}
		}
	},
	clearFormError: function(){
		if(this.errorContainer)
			this.errorContainer.hide().html('');
	},
	submit: function(){
		this.submitForm();
	},
	submitForm: function(e){
		if(this.isSubmitting)
			return false;
		if(this.isDisabled())
			return false;
		this.validate();
		if(this.valid)
		{
			if(this.annotations.hideSubmit){
				this.submit_button.hide();
			}
			if(this.annotations.realSubmit === true)
				return true;
			if(this.annotations.mode == "polling")
				this.poll();
			else
				this.sendFormData();
		}else{
			if(Finch.AjaxForm.errorHandler){
				Finch.AjaxForm.errorHandler(this.errors, this.getData());
			}
			this.setFormError('error');
		}
			
		return false;
	},
	validate: function(){
		this.valid = true;
		this.clearFormError();
		for(var name in this.fields){
			this.fields[name].validate();
		}
		if(this.validateFn)
			this.validateFn();
	},
	getData: function(){
		var data = {};
		for(var name in this.fields)
			data[name] = this.fields[name].val;
		return data;
	},
	poll: function(){
		if(this.isSubmitting)
			return;
		if(this.isDisabled())
			return;
		this.disableSubmit();
		this.isSubmitting = true;
		
		var parameters = this.getData();
		if(this.beforeSendFn)
			this.beforeSendFn(parameters);
		if(this.progress)
			this.progress.show();
		var url = this.getUrl();
		var f = Finch.Func.bind(function(){
			$.ajax({
				type:"post",
				data:parameters,
				cache:false,
				url:url,
				dataType:"json",
				success: Finch.Func.bind(function(response){
					if(response.url || response.targetUrl){
						if(this.intervalHandler)
							clearInterval(this.intervalHandler);
						if(this.progress)
							this.progress.hide();
						document.location.href = response.url ? response.url : response.targetUrl;
						return;
					}
					if(response.status == "pending")
						return;
					
					if(this.intervalHandler)
						clearInterval(this.intervalHandler);
					if(this.progress)
						this.progress.hide();
					if(response.status == "error"){
						this.enableSubmit();
						this.isSubmitting = false;
						if(response.error){
							this.setFormError(response.error, true);
						}
						else {
							if(response.errorCode){
								var e = this.getFormError("error");
								if(e == null){
									e = "";
								}
								e += " (" + response.errorCode + ")";
								this.setFormError(e, true);
							}else{
								this.setFormError("error");
							}							
						}							
						if(this.onError)
							this.onError(response);
						return;
					}
					
					if(response.status == "ok"){
						var responseValid = true;
						if(response.errors){
							for(var e in response.errors){
								responseValid = false;
								break;
							}
						}
						if(!responseValid){
							this.enableSubmit();
							this.isSubmitting = false;
							for(var i in response.errors){
								if(this.fields[i])
									this.fields[i].addError(response.errors[i]);
							}
							if(response.error)
								this.setFormError(response.error, true);
							else
								this.setFormError('error');
						}else{
							if(this.annotations.successUrl){
								if(this.annotations.successUrl == 'this')
									document.location.href = document.location.href;
								else
									document.location.href = this.annotations.successUrl;
								return;
							}
							if(response.data && response.data.targetUrl){
								document.location.href = response.data.targetUrl;
								return;
							}
							if(this.onSuccess)
								this.onSuccess(response);
						}
						return;
					}
				}, this),
				error: Finch.Func.bind(function(res){
					this.enableSubmit();
					this.isSubmitting = false;
					if(this.intervalHandler)
						clearInterval(this.intervalHandler);
					if(this.progress)
							this.progress.hide();	
					if(this.onError)
						this.onError(res);
					else
						this.setFormError('error');
				}, this)
			});
		}, this);
		
		f();
		this.intervalHandler = setInterval(f, 1500);
	},
	sendFormData: function(){
		var parameters = this.getData();
		if(this.beforeSendFn)
			this.beforeSendFn(parameters);
		if(this.replaceSend)
		{
			this.replaceSend(parameters);
			return;
		}
		var method = 'post';
		if(this.annotations.method)
			method = this.annotations.method;
		var url = this.getUrl();
		this.disableSubmit();
		this.isSubmitting = true;
		
		var dataType = this.annotations.jsonp ? "jsonp" : "json";
		var baseParams = {
			type:method,
			data:parameters,
			cache:false,
			url:url,
			dataType: dataType
		};
		if(dataType == "jsonp"){
			dataType.jsonpCallback = "jsonpCallback";
		}
		if(this.progress)
			this.progress.show();
		$.ajax($.extend(baseParams, {
			success: Finch.Func.bind(function(response){
				var res = response;
				if(this.progress)
					this.progress.hide();
				this.isSubmitting = false;
				this.enableSubmit();
				if(this.onResponse){
					this.onResponse(res);
					return;
				}
				if(res.valid){
					if(this.onSuccess)
					{
						this.onSuccess(res);
						return;
					}	
					if(this.annotations.successUrl){
						if(this.annotations.successUrl == 'this')
							document.location.href = document.location.href;
						else
							document.location.href = this.annotations.successUrl;
						return;
					}
					if(res.data && res.data.targetUrl){
						document.location.href = res.data.targetUrl;
						return;
					}
					this.setFormError('success');
				}
				else{
					if(res.data && res.data.targetUrl){
						document.location.href = res.data.targetUrl;
						return;
					}
					for(var i in res.errors){
						if(this.fields[i])
							this.fields[i].addError(res.errors[i]);
					}
					if(this.onError){
						this.onError(res);
					}
					this.setFormError('error');
				}
			}, this),
			error: Finch.Func.bind(function(res){
				this.enableSubmit();
				this.isSubmitting = false;
				if(this.progress)
					this.progress.hide();
				if(this.onError){
					this.onError(res);
					return;
				}
				if(res && res.data && res.data.targetUrl){
					document.location.href = res.data.targetUrl;
					return;
				}
				this.setFormError('failure');
			}, this)
		}));
	},
	getUrl: function(){
		var url = "/" + this.annotations.name + "/form";
		if(Finch.AjaxForm.options.prefix)
			url = Finch.AjaxForm.options.prefix + url;
		if(this.annotations.url)
			url = this.annotations.url;
		return url;
	},
	parseFields: function(){
		this.getFormAnnotations();
		var err_cont = $(".formErrorMessage", this.container);
		if(err_cont.length > 0)
			this.errorContainer = err_cont;
		$(".formItem", this.container).each(Finch.Func.bind(function(i, item){
			item = $(item);
			var annotations = this.getAnnotations(item);
			
			var name = this.getName(item, annotations);
			this.fields[name] = Finch.AjaxFormItemFactory.getItem(
				item,
				this,
				name,
				this.getType(item, annotations),
				this.getErrorContainer(item, annotations),
				annotations);
		}, this));
		if(this.annotations.validate)
			this.validateFn = Finch.Func.bind(this.parseMethod(this.annotations.validate), this);
		if(this.annotations.beforeSend)
			this.beforeSendFn = Finch.Func.bind(this.parseMethod(this.annotations.beforeSend), this);
		if(this.annotations.onError)
			this.onError = Finch.Func.bind(this.parseMethod(this.annotations.onError), this);
		if(this.annotations.onResponse)
			this.onResponse = Finch.Func.bind(this.parseMethod(this.annotations.onResponse), this);
		if(this.annotations.onSuccess)
			this.onSuccess = Finch.Func.bind(this.parseMethod(this.annotations.onSuccess), this);
		if(this.annotations.replaceSend)
			this.replaceSend = Finch.Func.bind(this.parseMethod(this.annotations.replaceSend), this);
	},
	addAnnotation: function(name, val){
		this.annotations[name] = val;
	},
	getType: function(element, annotations){
		if(annotations.type)
			return annotations.type;
		var input = $("input", element);
		if(input.length > 0)
			return input[0].type;
		if($("select", element).length > 0)
			return "select";
		if($("textarea", element).length > 0)
			return "textarea";
		return undefined;
	},
	getName: function(element, annotations){
		if(annotations.name)
			return annotations.name;
		var tagName = element.prop("tagName").toLowerCase();
		if(tagName == "input" || tagName == "select" || tagName == "textarea"){
			return element.attr("name");
		}
		var inp = $("input, select, textarea", element);
		if(inp.length == 0)
			return "";
		return inp.attr("name");
	},
	getErrorContainer: function(element, annotations){
		if(annotations.errorMessage)
			return $("#" + annotations.errorMessage);
		var cont = $(".errorMessage", element);
		if(cont.length > 0){
			return cont;
		}
		return null;
	},
	getFormAnnotations: function(){
		this.annotations = this.container.data();
	},
	enableSubmit: function(){
		this.submit_button.removeClass('disabled');
		this.submit_button.removeAttr("disabled");
	},
	disableSubmit: function(){
		if(this.submit_button.is('a')){
			this.submit_button.addClass('disabled');
			return this;
		}		
		this.submit_button.attr("disabled", "disabled");
	},
	isDisabled: function(){
		if(this.submit_button.hasClass("disabled"))
			return true;
		if(this.submit_button.attr("disabled") == "disabled")
			return true;
		return false;
	},
	getAnnotations: function(element){
		var annotations = element.data();
		annotations.errors = {};
		for(var annotation in annotations){
			if(annotation != 'errors' && annotation.indexOf("error") == 0){
				var e = annotation.replace(/^error/,"");
				annotations.errors[this.convertCameCaseToSnake(e)] = annotations[annotation];
			}
		}
		return annotations;
	},
	convertCameCaseToSnake: function(str){
		if(str.indexOf('_') > 0)
			return str.toLowerCase();
		var l = str.length;
		var words = [];
		var buffer = "";
		for(var i = 0; i < l; i++){
			if(str.charCodeAt(i) < 97 && i > 0){
				words.push(buffer.toLowerCase());
				buffer = "";
			}
			buffer += str.charAt(i);
		}
		words.push(buffer.toLowerCase());
		return words.join(".");
	},
	convertSnakeToCameCase: function(str){
		var l = str.length;
		var result = "";
		for(var i = 0; i < l; i++){
			if(str.charAt(i) == '.'){
				result += str.charAt(i + 1).toUpperCase();
				i++;
			}else{
				result += str.charAt(i);
			}
		}
		return result;
	},
	parseMethod: function(str){
		var parts = str.split('.');
		var target = window;
		var method = parts.pop();
		for(var i = 0; i < parts.length; i++)
			target = target[parts[i]];
		return target[method];
	},
  showPopup: function(){
    var popup = $(".js-successPopup");
    var $body = $('body');
    $body.css('overflow', 'hidden');
    popup.show();
  }
});

Finch.AjaxForm.options = {};
Finch.AjaxForm.init = function(){
	Finch.AjaxForm.forms = {};
	$(".form").each(function(i, el){
		var f = new Finch.AjaxForm($(el));
		Finch.AjaxForm.forms[f.annotations.name] = f;
	});
};

Finch.AjaxFormItemFactory = Finch.Class.create({});

Finch.AjaxFormItemFactory.getItem = function(element, form, name, type, errorContainer, annotations){
	if(annotations.clazz){
		var clazz = form.parseMethod(annotations.clazz);
		return new clazz(element, form, name, type, errorContainer, annotations);
	}
	if(type == "textarea")
		return new Finch.TextAreaFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "float")
		return new Finch.FloatFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "integer")
		return new Finch.IntegerFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "email")
		return new Finch.EmailFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "select")
		return new Finch.SelectFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "checkbox")
		return new Finch.CheckboxFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "radio")
		return new Finch.RadioFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "date")
		return new Finch.DateFormItem(element, form, name, type, errorContainer, annotations);
	if(type == "multicheck")
		return new Finch.MultiCheckboxFormItem(element, form, name, type, errorContainer, annotations);
	return new Finch.TextFormItem(element, form, name, type, errorContainer, annotations);
};

Finch.TextFormItem = Finch.Class.create({
	initialize: function(element, form, name, type, errorContainer, annotations){
		this.element = element;
		this.form = form;
		this.name = name;
		this.type = type;
		this.val = null;
		this.errorContainer = errorContainer;
		this.annotations = annotations;
		if(this.annotations.init)
			this.initFn = Finch.Func.bind(this.form.parseMethod(this.annotations.init), this);
		this.init();		
	},
	init: function(){
		if(this.initFn)
		{
			this.initFn();
			return;
		}
		if(this.element.prop("tagName").toLowerCase() == "input"){
			this.control = this.element;
		}else{
			this.control = $("input", this.element);
		}
		
		if(!this.annotations["no-enter"]){
			this.control.keypress(Finch.Func.bind(function(event){
				if(event.which == 13)
					this.form.submitForm(null);
			}, this));
		}		
	},
	value: function(){
		var enforce = arguments.length > 0 && arguments[0];
		if(!enforce)
			return this.val;
		this.val = this.control.val();
		return this.val;
	},
	validate: function(){
		this.clearError();
		this.value(true);
		if(!this.val && this.annotations.required === true)
		{
			this.addError('required');
			return;
		}
		if(this.annotations.length){
			var l = parseInt(this.annotations.length);
			if(this.val && this.val.length != l)
				this.addError("wrong.length");
		}
		if(this.annotations.minlength){
			var minl = parseInt(this.annotations.minlength);
			if(this.val.length < minl)
				this.addError("short.length");
		}
		if(this.annotations.maxlength){
			var maxl = parseInt(this.annotations.maxlength);
			if(this.val.length > maxl)
				this.addError("long.length");
		}
		if(this.annotations.regexp){
			var r = new RegExp(this.annotations.regexp);
			if(this.val && !this.val.match(r))
				this.addError("wrong.format");
		}
	},
	addError: function(error){
		this.error = true;
		this.form.valid = false;
		this.element.addClass("formItemError");
		var e_c = this.errorContainer;
		if(e_c && this.annotations.errors[error]){
			this.errorContainer.show().html(this.annotations.errors[error]);
		}
		if(this.form.errorContainer && this.annotations.errors[error] && this.form.errorContainer.html() == '')
			this.form.errorContainer.show().html(this.annotations.errors[error]);
	},
	clearError: function(){
		this.error = false;
		this.element.removeClass("formItemError");
		
		if(this.errorContainer){
			this.errorContainer.hide().html('');
		}
	}
});

Finch.TextAreaFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function(){
		this.control = $("textarea", this.element);
		if(!this.annotations["no-enter"])
			this.control.keypress(Finch.Func.bind(function(event){
				if(event.which == 13 && event.ctrlKey)
				{
					this.form.submitForm(null);
				}	
			}, this));
	},
	value: function(){
		if(this.valueFn)
		{
			this.val = this.valueFn();
			return this.val;
		}
		this.val = this.control.val();
		return this.val;
	}
});

Finch.IntegerFormItem = Finch.Class.create(Finch.TextFormItem, {
	validate: function($super){
		$super();
		if(!this.form.valid)
			return;
		var regExp = /^([\d]+)$/;
		if(!this.val.match(regExp))
			this.addError("wrong.format");
	}
});

Finch.FloatFormItem = Finch.Class.create(Finch.TextFormItem, {
	validate: function($super){
		$super();
		if(!this.form.valid)
			return;
		var regExp = /^([\d]+(\.)?[\d]*)$/;
		if(!this.val.match(regExp))
			this.addError("wrong.format");
	}
});

Finch.SelectFormItem = Finch.Class.create(Finch.TextFormItem, {
	supportsDynamicChanges: false,
	init: function(){
		this.control = $("select", this.element);
	
	},
	value: function(){
		if(this.valueFn)
		{
			this.val = this.valueFn();
			return this.val;
		}
		this.val = this.control.val();
		if(this.val == 'nil')
			this.val = null;
		return this.val;
	}
});

Finch.CheckboxFormItem = Finch.Class.create(Finch.TextFormItem, {
	supportsDynamicChanges: "click",
	init: function(){
		this.control = $("input:checkbox", this.element);
	},
	value: function(){
		if(this.valueFn)
		{
			this.val = this.valueFn();
			return this.val;
		}
		var enforce = arguments.length > 0 && arguments[0];
		if(!enforce)
			return this.val;
		this.val = $("input:checked", this.element).length > 0;
		return this.val;
	}
});

Finch.RadioFormItem = Finch.Class.create(Finch.TextFormItem, {
	supportsDynamicChanges: false,
	init: function(){},
	value: function(){
		if(this.valueFn)
		{
			this.val = this.valueFn();
			return this.val;
		}
		var enforce = arguments.length > 0 && arguments[0];
		if(!enforce)
			return this.val;
		var c = $("input[type=radio]", this.element).is("[checked]");
		if(!c)
			return null;
		this.val = $("input:checked[type=radio]", this.element).val();
		return this.val;
	}
});

Finch.EmailFormItem = Finch.Class.create(Finch.TextFormItem, {
	validate: function($super){
		$super();
		if(this.error || !this.val)
			return;
		var regExp = /^[a-z0-9+._-]+@[a-z0-9+.-]+\.[a-z]{2,}$/i;
		if(this.val.indexOf(" ") > -1)
		{
			this.addError("spaces");
			return;
		}
		var cyrillicExp = /[а-яА-Я]/;
		if(this.val.match(cyrillicExp))
		{
			this.addError("cyrillic");
			return;
		}
		if(this.val && !this.val.match(regExp))
			this.addError("wrong.format");
	}
});


Finch.DateFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function(){
		this.control = $("select[name=day]", this.element);
		this.controls = {};
		this.controls.day = $("select[name=day]", this.element);
		this.controls.month = $("select[name=month]", this.element);
		this.controls.year = $("select[name=year]", this.element);
		if(this.controls.year.length == 0)
			this.controls.year = null;
		this.controls.time = $("input[name=time]", this.element);
		if(this.controls.time.length == 0)
			this.controls.time = null;
		this.controls.yearInp = $("input[name=year]", this.element);
		if(this.controls.yearInp.length == 0)
			this.controls.yearInp = null;
	},
	value: function(){
		var enforce = arguments.length > 0 && arguments[0];
		if(!enforce)
			return this.val;
		var day, month, year, time = '';
		var val = 1;
		if(this.controls.day.val() != 'nil')
			day = this.controls.day.val();
		else
			val = null;
		if(this.controls.month.val() != 'nil')
			month = this.controls.month.val();
		else
			val = null;
		if(this.controls.year)
		{
			if(this.controls.year.val() != 'nil')
				year = this.controls.year.val();
			else
				val = null;
		}
		if(this.controls.yearInp && this.controls.yearInp.css("display") != "none")
		{
			var rp = new RegExp("[1-9][0-9][0-9][0-9]");
			if(this.controls.yearInp.val().match(rp))
				year = this.controls.yearInp.val();
			else
				val = null;
		}
		if(val == null)
		{
			this.val = null;
			return null;
		}
		if(this.controls.time && $.trim(this.controls.time.val()) != ""){
			var v = $.trim(this.controls.time.val());
			var regExp = new RegExp("\\d\\d:\\d\\d");
			if(v.match(regExp)){
				var vs = v.split(":");
				var h = parseInt(vs[0]);
				var m = parseInt(vs[1]);
				if(h > 23 || m > 59)
				{
					this.addError("not.valid");
					time = null;
				}
			}else{
				this.addError("not.valid");
				time = null;
			}
			if(time != null)
				time = v + ":00";
		}
		var result = year + "-";
		var date = new Date();
		date.setYear(year);
		date.setMonth(month);
		date.setDate(day);
		if(date.getMonth() != month)
			this.addError("not.valid");
		if(month.length < 2)
			result += "0" + (eval(month) + 1) + "-";
		else
			result += (eval(month) + 1) + "-";
		if(day.length < 2)
			result += "0" + day;
		else
			result += day;
		if(time != null)
			result += " " + time;
		this.val = result;
		return this.val;
	}
});

Finch.MultiCheckboxFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function(){},
	value: function(){
		var enforce = arguments.length > 0 && arguments[0];
		if(!enforce)
			return this.val;
		var v = $("checbox:checked", this.element).val();
		if(!v)
			this.val = null;
		else
			this.val = v.join(",");
		return this.val;
	}
});