var Finch = Finch || {};

Finch.Class = (function() {
  function subclass() {};
  function create() {
    var parent = null, properties = Finch.Iterator(arguments);
    if (Finch.Utils.isFunction(properties[0]))
      parent = properties.shift();
 
    function klass() {
      this.initialize.apply(this, arguments);
    }
 
    Finch.Utils.extend(klass, Finch.Class.Methods);
    klass.superclass = parent;
    klass.subclasses = [];
 
    if (parent) {
      subclass.prototype = parent.prototype;
      klass.prototype = new subclass;
      parent.subclasses.push(klass);
    }
 
    for (var i = 0; i < properties.length; i++)
      klass.addMethods(properties[i]);
 
    if (!klass.prototype.initialize)
      klass.prototype.initialize = function() { };
 
    klass.prototype.constructor = klass;
    return klass;
  }
 
  function addMethods(source) {
    var ancestor   = this.superclass && this.superclass.prototype;
    var properties = Finch.Utils.keys(source);
 
    if (!Finch.Utils.keys({ toString: true }).length) {
      if (source.toString != Object.prototype.toString)
        properties.push("toString");
      if (source.valueOf != Object.prototype.valueOf)
        properties.push("valueOf");
    }
 
    for (var i = 0, length = properties.length; i < length; i++) {
      var property = properties[i], value = source[property];
      if (ancestor && Finch.Utils.isFunction(value) && Finch.Func.argumentNames(value)[0] == "$super") {
        var method = value;
        value = Finch.Func.wrap((function(m) {
          return function() { return ancestor[m].apply(this, arguments); };
        })(property), method);
 
        value.valueOf = Finch.Func.bind(method.valueOf, method);
        value.toString = Finch.Func.bind(method.toString, method);
      }
      this.prototype[property] = value;
    }
 
    return this;
  }
 
  return {
    create: create,
    Methods: {
      addMethods: addMethods
    }
  };
})();

Finch.Iterator = function(iterable){
	if(!iterable)
		return [];
  	if('toArray' in Object(iterable))
  		return iterable.toArray();
	var length = iterable.length || 0, results = new Array(length);
	while (length--)
		results[length] = iterable[length];
	return results;
};

Finch.Func = {
	argumentNames: function(func){
		var names = func.toString().match(/^[\s\(]*function[^(]*\(([^)]*)\)/)[1].replace(/\/\/.*?[\r\n]|\/\*(?:.|[\r\n])*?\*\//g, '').replace(/\s+/g, '').split(',');
		return names.length == 1 && !names[0] ? [] : names;
	},
	bind: function(func, context){
		return function() {
			return func.apply(context, arguments);
		};
	},
	wrap: function(func, wrapper){
		return function(){
			var a = Finch.Utils.update([Finch.Func.bind(func, this)], arguments);
			return wrapper.apply(this, a);
		};
	}
};

Finch.Utils = Finch.Utils || {};

Finch.Utils.extend = function(destination, source){
	for (var property in source)
		destination[property] = source[property];
	return destination;
};

Finch.Utils.extend(Finch.Utils, {
	keys: function(object){
		var results = [];
		for(var property in object)
			results.push(property);
		return results;
	},
	values: function(object){
		var results = [];
		for(var property in object)
			results.push(object[property]);
		return results;
	},
	clone: function(object) {
		return extend({ }, object);
	},
	isElement: function(object) {
		return !!(object && object.nodeType == 1);
	},
	isArray: function(object){
		return Object.prototype.toString.call(object) == "[object Array]";
	},
	isFunction: function(object){
		return typeof object === "function";
	},
	isString: function(object){
		return Object.prototype.toString.call(object) == "[object String]";
	},
	isNumber: function(object){
		return _toString.call(object) == "[object Number]";
	},
	isUndefined: function(object){
		return typeof object === "undefined";
	},
	update: function(array, args){
		var arrayLength = array.length, length = args.length;
		while (length--)
			array[arrayLength + length] = args[length];
		return array;
	}
});