$(function(){
	if($("#map").length > 0){
		ymaps.ready(function(){
			var c = [55.7522200, 37.6155600];
			var zoom = 10;
			if(window.library){
				c = [library.lat, library.lon];
				zoom = 16;
			}
			var myMap = new ymaps.Map("map", {center: c, zoom: zoom});
			myMap.behaviors.disable('scrollZoom');
			var objectManager = new ymaps.ObjectManager({clusterize: true, gridSize: 64});
			
			objectManager.objects.options.set('preset', 'islands#darkBlueDotIcon');
			objectManager.clusters.options.set('preset', 'islands#darkBlueClusterIcons');
			myMap.geoObjects.add(objectManager);
			var url = "/map/json";
			if($("#map").data("url")){
				url = $("#map").data("url");
			}
			$.ajax({url: url}).done(function(data) {
				objectManager.add(data);
				if(window.library && !window.library.showClosed){
					objectManager.objects.balloon.open(window.library.id);
					
				}				
		    });
		});	
	}
	
	$(".popup .close").click(function(){
		$(".popup").hide();
		return false;
	});
	$(".popup2 .close").click(function(){
		$(".popup2").hide();
		return false;
	});
	
	$(".site-content").click(function(){
		var locked = false;
		$(".popup, .popup2").each(function(i, item){
			if($(item).find(".close").attr("id") == "librarian_order" && window.order_popup_locked){
				locked = true;
				return false;
			}else{
				$(item).hide();
			}
		});
		if(locked){
			return false;
		}
	});
	
	$(".guest .enter").click(function(){
		Popup.open("login");
		return false;
	});
	
	$(".reg").click(function(){
		Popup.load("/reg");
		window.scroll(0, 0);
		return false;
	});
});

$(function(){
	var form = $(".booking-form");
	if(form.length == 0){
		return;
	}
	$("a", form).click(function(){
		Order.search();
		return false;
	});
	$("input", form).keypress(function(e){
		if(e.which == 13){
			Order.search();
		}
	});
});

var Book = {
    found: function (el, id) {
        $.post(el.href, {id: id}, function(){
            $(el).remove()
        });
    }
}

var Order = {
	search: function(){
		var v = $(".booking-form input").val();
		if(!v){
			alert('Введите номер заказа');
			return false;
		}
		if(!parseInt(v)){
			alert('Номер заказа должен быть числом');
			return false;
		}
		Popup.load('/librarian/order/' + parseInt(v));
	},
	taken: function(el, item, order){
		$.post("/librarian/taken", {id: item}, function(data){
			Popup.load('/librarian/order/' + order);
		});
	},
	refusedLibrarian: function(el, item, order){
		$.post("/librarian/refused", {id: item}, function(data){
			Popup.load('/librarian/order/' + order);
		});
	},
    exTaken: function(el, order){
		el.style.display = 'none';
        $.post("/librarian/extaken", {id: order}, function(data){
           	return location.reload()
        });
    },
	exRefusedLibrarian: function(el, order){
        el.style.display = 'none';
		$.post("/librarian/exrefused", {id: order}, function(data){
            return location.reload()
        });
	},
	extend: function(id){
		$.post("/order/extend", {id: id}, function(data){
			Popup.load('/profile');
		});
	},
	refuse: function(id){
		$.post("/order/refuse", {id: id}, function(){
			$("#item" + id).remove();
		});
	},
	onAbsent: function(){
		document.location.href = document.location.href;
	},
	confirm: function(el, id){
		$.post(el.href, {id: id}, function(){
			document.location.href = document.location.href;
		});
	},
	current: null,
	load: function(el, id){
		$.get("/order/load/" + id, function(html){
			$("tr.load").hide();
			var load = $(el).parents(".item").next();
			if(id == Order.current){
				Order.current = null;
				return;
			}
			Order.current = id;
			$("td.load-container", load).html(html);
			load.show();
		});
	}
}

var Cart = {
	add: function(id, fundType, currentFundType){
		currentFundType = Cart.fundType ? Cart.fundType : currentFundType;
		if (currentFundType && currentFundType != fundType) {
			var result = confirm('Внимание! В корзине не могут одновременно находиться издания из ветхого и обменного фонда! При выборе изданий из другого фонда, ранее отложенные в "корзину" позиции будут удалены. Хотите продолжить?')
			if (!result) return
		}
		$.post("/cart/add", {id: id}, function(data){
			if(data.status == "limit"){
				alert('В сутки вы можете заказать не более ' + data.limit + ' книг');
				return;
			}
            if(data.status == "wasadded"){
                alert('Эту книгу уже кто-то добавил в корзину');
                return;
            }
            if(data.status == "notloggedin"){
                alert('Вы не авторизованы в системе');
                return;
            }
            if (data.status == "notavailable") {
				alert('Книга недоступна');
				return;
			}

            if(data.fund_type) {
            	Cart.fundType = data.fund_type;
			}
			$("#book" + id + " .controls a").toggle();
			Cart.bind(data.total);
			$(".button a").toggle();
		});
	},
	addSingle: function(id){
		$.post("/cart/add", {id: id}, function(data){
			if(data.status == "limit"){
				alert('В сутки вы можете заказать не более ' + data.limit + ' книг');
				return;
			}
            if(data.status == "wasadded"){
                alert('Эту книгу уже кто-то добавил в корзину');
                return;
            }
            if(data.status == "notloggedin"){
                alert('Вы не авторизованы в системе');
                return;
            }
            if (data.status == "notavailable") {
                alert('Книга недоступна');
                return;
            }

			$(".button a").toggle();
			Cart.bind(data.total);
			$("#book" + id + " .controls a").toggle();			
		});
	},
	remove: function(id){
		$.post("/cart/delete", {id: id}, function(data){
			$("#book" + id + " .controls a").toggle();
			Cart.bind(data.total);
			$(".button a").toggle();
		});
	},
	removeSingle: function(id){
		$.post("/cart/delete", {id: id}, function(data){
			$(".button a").toggle();
			Cart.bind(data.total);
			$("#book" + id + " .controls a").toggle();
		});
	},
	removeFromList: function(id){
		$.post("/cart/delete", {id: id}, function(data){
			$("#book" + id + " .controls a").toggle();
			$("#item" + id).remove();
			Cart.bind(data.total);
			if(data.total == 0){
				$("#cart_items").hide();
				$("#no_items").show();
			}
		});
	}, 
	order: function(){
		$.post("/order", {}, function(data){
			if(data.status == 'error'){
				var e = data.error;
				if(!data.error){
					e = 'Попробуйте еще раз';
				}
				$("#error span").html(e);
				$("#error").show();
				return;
			}
			$("#error").hide();
			$("#cart_items").hide();
			$("#success").show();
			$("[id^=book] .controls a.add").show();
			$("[id^=book] .controls a.remove").hide();
			Cart.bind(0);
			window.scroll(0, 0);
		});
	},
	bind: function(total){
		var container = $(".second-line .books");
		$("i", container).html(total);
		$("span span", container).html(total + " " + Cart.word(total, container.get(0).onclick()));
	},
	word: function(n, forms){
		var last = n % 10;
		var sec = n % 100;
		if(last == 0)
			return forms[2];
		if(sec > 10 && sec < 20)
			return forms[2];
		if(last == 1)
			return forms[0];
		if(last < 5)
			return forms[1];
		return forms[2];
	},
	onGenericOrder: function(res){
	    console.log(res);
		$("#error").hide();
		$("#cart_items").hide();
		$("#success2").append('<p>Заказ № ' + res.data.order + '.</p>');
		$("#success2").show();
		$("[id^=book] .controls a.add").show();
		$("[id^=book] .controls a.remove").hide();
		Cart.bind(0);
		window.scroll(0, 0);
	}
}

var Popup = {
	open: function(id){
		$(".popup .success").hide();
		$(".popup .data-block").show();
		$(".popup2 .success").hide();
		$(".popup2 .data-block").show();
		$(".popup, .popup2").hide();
		$('#' + id).show();
	},
	load: function(url){
		var c = $("#load_popups");
		c.empty();
		$.get(url, function(html){
			c.html(html);
			var popup = $(".popup, .popup2", c);
			Popup.open(popup.get(0).id);
			$(".close", popup).click(function(){
				if(this.id == "librarian_order" && window.order_popup_locked){
					alert('Завершите, пожалуйста, выдачу книг');
					return false;
				}
				$(".popup, .popup2").hide();
				return false;
			});
		});
	},
	reset: function(){
		Popup.load('/reset');
	},
    first: function(){
        Popup.load('/first');
    }
}

var Forms = {
	onRegister: function(){		
		$("#register .data-block").hide();
		$("#register .success").show();
		window.scrollTo(0, 0);
	},
	onRegError: function(){
		for(var item in ReCaptcha.items){
			grecaptcha.reset(ReCaptcha.items[item]);
		}
		$(".captcha img").attr("src", "/captcha?rnd=" + Math.random());
	},
	onReset: function(){
		$("#reset .data-block").hide();
		$("#reset .success").show();
		window.scrollTo(0, 0);
	},
	onPasswordChange: function(){
		$("#change .data-block").hide();
		$("#change .success").show();
		window.scrollTo(0, 0);
	},
    onTelChange: function(res){
       Popup.load('/profile/tel-confirm?phone='+res.data.phone);
       return false;
    },
	onTelConfirm: function(res){
    	$("#confirmMobile .data-block").hide();
        $("#confirmMobile .success").show();
	},
	onFeedback: function(){
		$("#feedback .form").hide();
		$("#feedback .success").show();
	},
    onFirstLogIn: function(res){
        $.post("/first", {}, function(data) {
            if (data.status == 'passed') {
                return data.status;
            }
        });
    },
};

var ReCaptcha = {
	items: {},
	init:function(){
		$("[id^=recaptcha]").each(function(i, item){
			var widgetId = grecaptcha.render(item, {sitekey: '6Ldd8hoUAAAAANzSCayuKxi8VfkpGCHMrhb6ZumD'});
			ReCaptcha.items[item.id] = widgetId;
		});
	}
}

Forms.RecaptchaFormItem = Finch.Class.create(Finch.TextFormItem, {
	value: function($super){
		var field = $("[name=g-recaptcha-response]", this.element);
		if(field.length == 0 || field.val() == ""){
			return null;
		}
		this.val = field.val();
		return this.val;
	}
});

Forms.CaptchaFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function($super){
		$super();
		var el = this.element;
		$("a", el).click(function(){
			$("img", el).attr("src", "/captcha?rnd=" + Math.random());
			return false;
		});
	},
	value: function($super){
		var field = $("input", this.element);
		if(field.val() == ""){
			return null;
		}
		this.val = field.val();
		return this.val;
	}
});

Forms.BirthDate = Finch.Class.create(Finch.TextFormItem, {
	init: function($super){
		$super();
		// $("[name=birth_date]").mask("99/99/9999", {placeholder:"дд/мм/гггг"});
	},
});

Forms.PhoneFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function($super){
		$super();
		$("[name=phone]").mask("(999) 999-9999");
	},
	validate: function($super){
		$super();
		if(this.error || !this.val)
			return;
		if(!this.val.match(/\d.*\d.*\d.*\d.*\d/)){
			this.addError('required');
		}
	}
});

Forms.PasswordFormItem = Finch.Class.create(Finch.TextFormItem, {
	validate: function($super){
		$super();
		if(this.val != this.form.fields.password.val){
			this.addError('not.valid');		
		}
	}
});

Forms.CustomRadioFormItem = Finch.Class.create(Finch.TextFormItem, {
	init: function($super){
		$super();
		var controls = $(".radio", this.element);
		controls.each(function(i, item){
			$(item).click(function(){
				controls.removeClass("checked");
				$(this).addClass("checked");
			});
		});
	},	
	value: function($super){
		var checked = $(".checked", this.element);
		if(checked.length == 0){
			return null;
		}
		this.val = checked.data("value");
		return this.val;
	}
});

Forms.FioFormItem = Finch.Class.create(Finch.TextFormItem, {
	validate: function($super){
		$super();
		if(this.error || !this.val)
			return;
		this.val = jq.trim(this.val);
		if(this.val.indexOf(" ") < 0){
			this.addError('required');
		}
	}
});

try{
	Finch.AjaxForm.init();
}catch(e){
	console.log(e);
}

var BooksFilter = {
	getUrl: function(library){
		var sl = $(".search-line");
		var url = "/books";
		if(sl.data("url")){
			url = sl.data("url");
		}
		if(window.baseBooksUrl){
			url = window.baseBooksUrl;
		}
		if(library){
			url += "/library/" + library;
		}else if(window.library && $("[name=library]").length > 0 && $("[name=library]").val() == window.library_name){
			url += "/library/" + window.library;
		}
		var age = $("select[name=age]").val();
		if(age != "nil"){
			url += "/age/" + age;
		}
        var type = $("select[name=type]").val();
        if(type != "nil"){
            url += "/type/" + type;
        }
		var category = $("select[name=category]").val();
		if(category != "nil"){
            var categoriesStr = location.pathname.match(/category\/([0-9,]+)/);
			if(!categoriesStr){
                url += "/category/" + category;
			} else {
                item = categoriesStr[1].split(',');
                var index = item.indexOf(category);
                if(index === -1){
                    item.push(category);
				}
                url += "/category/" + item.join(',');
            }
        }
        var region = $("select[name=region]").val();
        if(region != "nil"){
            url += "/region/" + region;
        }
        var district = $("input[name=district]").val();
        if(district){
            url += "/district/" + district;
        }
        var metro = $("input[name=metro]").val();
        if(metro){
            url += "/metro/" + metro;
        }
        var lang = $("select[name=lang]").val();
        if(lang && lang != "nil"){
            url += "/lang/" + lang;
        }
        var fund = $("select[name=fund]").val();
        if(fund && fund != "nil"){
            url += "/fund/" + fund;
        }
		var author = $(".search-line [name=author]").val();
		var name = $(".search-line [name=name]").val();
		if(name){
			url += "?title=" + name;
		}
		if(author){
			if(url.indexOf('?') > 0){
				url += "&author=" + author;
			}else{
				url += "?author=" + author;
			}
		}
		return url
	}
};

$(function(){
	var sl = $(".search-line");
	if(sl.length == 0){
		return;
	}
	$("select", sl).each(function(i, select){
		select = $(select);
		select.on("change", function(){
			document.location.href = BooksFilter.getUrl();
		});
	});
});

$(function(){
	var author = $(".search-line [name=author]");
	if(author.length == 0){
		return;
	}
	author.keypress(function(event){
		if(event.which == 13){
			document.location.href = BooksFilter.getUrl();
		}			
	});
	author.next().click(function(){
		document.location.href = BooksFilter.getUrl();
		return false;
	});
	author.autocomplete({
		source: "/books/author",
		select: function(event, ui){
			author.val(ui.item.label);
			return false;
		},
		focus: function(event, ui){
			return false;
		}
	});
});

$(function(){
	var title = $(".search-line [name=name]");
	if(title.length == 0){
		return;
	}
	title.keypress(function(event){
		if(event.which == 13 && title.val()){
			document.location.href = BooksFilter.getUrl();
		}			
	});
	title.next().click(function(){
		if(title.val()){
			document.location.href = BooksFilter.getUrl();
		}
		return false;
	});
});

var Review = {
	send: function(id){
		var form = $(".review .fields");
		var rating = $("select", form).val();
		var comment = $("textarea", form).val();
		$.post("/review/send", {rating: rating, comment: comment, id: id}, function(){
                        // save count of reviews for auto popup functionality
                        var reviewCookie = Review.getCookie('review')
                        if( reviewCookie != undefined ){
                            reviewTimes = parseInt(reviewCookie) + 1;
                            document.cookie = "review=" + reviewTimes;
                        }else{
                            document.cookie = "review=1";
                        }
			form.hide();
			$(".review .success").show();
			window.scroll(0, 0);
		});
	},
        
        getCookie: function(name){
            var matches = document.cookie.match(new RegExp(
              "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
            ));
            return matches ? decodeURIComponent(matches[1]) : undefined;
        },
        
        refuse: function(id){
                var form = $(".review .fields");
		$.post("/review/refuse", {id: id}, function(){
			form.hide();
			$(".review .refused").show();
			window.scroll(0, 0);
		});
	},
};

$(function(){
	var animated = $(".animated-logo");
	if(animated.length == 0){
		return;
	}
	var offset = 100;
	var config = [
	    {pos: 82, speed: 1000, delay: 100}, 
	    {pos: 82, speed: 1100, delay: 10},
	    {pos: 145, speed: 1100, delay: 100},
	    {pos: 235, speed: 1100, delay: 200},
	    {pos: 295, speed: 1100, delay: 300},
	    {pos: 292, speed: 1200, delay: 250},
	    {pos: 363, speed: 1100, delay: 400},
	    {pos: 445, speed: 1100, delay: 500},
	    {pos: 533, speed: 1100, delay: 600},
	    {pos: 595, speed: 1100, delay: 700},
	    {pos: 682, speed: 1000, delay: 1100}, 
	    {pos: 682, speed: 1100, delay: 1000},
	    {pos: 745, speed: 1100, delay: 1100},
	    {pos: 835, speed: 1100, delay: 1200},
	    {pos: 895, speed: 1100, delay: 1300},
	    {pos: 892, speed: 1200, delay: 1250},
	    {pos: 963, speed: 1100, delay: 1400},
	    {pos: 1045, speed: 1100, delay: 1500},
	    {pos: 1133, speed: 1100, delay: 1600},
	    {pos: 1195, speed: 1100, delay: 1700}
	];
	$("i[class^=book]", animated).hide();
	for(var i = 0; i < config.length; i++){
		(function(n){
			var s = config[n - 1];
			setTimeout(function(){
				var pic = $("i.book" + n, animated);
				var start = (animated.width() + 100) + "px";
				var to = (offset + s.pos) + "px";
				pic.css({left: start}).show().animate({left: to}, s.speed);
			}, s.delay);
		})(i + 1);	
	}
});

$(function(){
	var select = $(".library-select");
	if(select.length == 0){
		return;
	}
	select.click(function(){
		return false;
	});
	$("body").click(function(){
		select.hide();
	});
	$("a.sel").click(function(){
		select.toggle();
		return false;
	});
	var input = $("input[name=library]");
	if(window.library){
		for(var i = 0; i < libraries.length; i++){
			if(libraries[i].value == window.library){
				input.val(libraries[i].label);
				window.library_name = libraries[i].label;
				break;
			}
		}
	}
	$.widget("book.bookAutoComplete", $.ui.autocomplete, {
		_renderItem: function( ul, item ) {
			var span = $("<span></span>").append(item.address);
			var div = $("<div></div>").append(item.name);
			return $( "<li></li>" ).append($("<div></div>").append(div).append(span)).appendTo( ul );
		}
	} );
	input.bookAutoComplete({
		source: window.libraries,
		search: function(event, ui){
			
		},
		select: function(event, ui){
			document.location.href = BooksFilter.getUrl(ui.item.value);
			return false;
		},
		focus: function(event, ui){
			return false;
		}		
	});
	$("a", select).click(function(){
		document.location.href = BooksFilter.getUrl($(this).data("library"));
		return false;
	});
});