import axios from 'axios'

/**
 * Cart manipulation
 */
export default class Cart {
    constructor() {
        this.cart = document.querySelector('#cart')

        this.buttons = [...document.querySelectorAll('.add_book, .remove_book')].forEach(button => {
            button.addEventListener('click', (e) => {
                if (e.target.classList.contains('remove_book')) return this.remove(button.dataset.bookid, button)

                return this.add(button.dataset.bookid, button)
            })
        })

        if (document.querySelector('#cartOrder')) {
            this.orderButton = document.querySelector('#cartOrder')
            this.orderButton.addEventListener('click', () => this.order())
        } else {
            this.orderButton = false;
        }

        this.cartList = document.querySelector('#cartList')
        this.cartText = document.querySelector('#cartText')

    }

    order() {
        axios.post('/order', {})
            .then(({data}) => {
                if (data.status === 'ok') {
                    this.cartList.remove()
                    const textMessage = document.createElement('p')
                    textMessage.innerHTML = `Ваш заказ поступил в обработку. <br/> 
Когда книги можно будет забрать, мы отправим Вам письмо на электронный адрес. <br>
Статус готовности заказа Вы можете отследить в личном кабинете.
`
                    this.cartText.appendChild(textMessage)
                }
            })
            .catch(err => alert(err))
    }

    add(id, button) {
        axios({
            method: 'post',
            url: '/cart/add',
            data: {id},
            transformRequest: [function (data, headers) {
                const form = new FormData
                form.append('id', id)
                return form
            }]
        })
            .then(({data}) => {
                if (data.status === "limit") {
                    throw('В день можно заказать не больше 10 книг')
                }

                Cart.updateButton(button, this.remove.bind(this))
                return this.updateCart(data.total)
            })
            .catch(err => alert(err))
    }

    remove(id, button) {
        axios({
            method: 'post',
            url: '/cart/delete',
            data: {id},
            transformRequest: [function (data, headers) {
                const form = new FormData
                form.append('id', id)
                return form
            }]
        })
            .then(({data}) => {
                Cart.updateButton(button, this.add.bind(this))
                return this.updateCart(data.total)
            })
            .catch(err => alert(err))
    }

    updateCart(count) {
        this.cart.querySelector('#cart_count').textContent = count
        $(this.cart).fadeIn(400).delay(1000).fadeOut(400)
    }

    static updateButton(button, callback) {
        button.classList.toggle('add_book')
        button.classList.toggle('remove_book')

        const cloneButton = button.cloneNode(true)
        cloneButton.addEventListener('click', ({target}) => callback(target.dataset.bookid, target))
        button.parentNode.replaceChild(cloneButton, button)
    }
}