export default class WidgetFactory {
    initWidgets() {
        const scripts = document.querySelectorAll('script[type="application/widget+json"]')

        const parsedData = [...scripts].map(script => JSON.parse(script.innerHTML));

        this.loadWidgets(parsedData)
    }

    loadWidgets(parsedData) {
        this.widgets = [...parsedData].map(widget => {
            return {
                name: widget.widget,
                data: widget.data
            }
        })

        this.widgets.forEach(widget => this.startWidget(widget))
    }

    startWidget({name, data}) {
        import(`./widgets/${name}`).then(module => {
            const widget = new module.default(data)
        })
            .catch(err => this.handleError(err))
    }

    handleError(err) {
        console.log(err)
    }
}

