webpackJsonp([5],{

/***/ 15:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _Widget2 = __webpack_require__(14);

var _Widget3 = _interopRequireDefault(_Widget2);

var _axios = __webpack_require__(3);

var _axios2 = _interopRequireDefault(_axios);

var _livr = __webpack_require__(16);

var _livr2 = _interopRequireDefault(_livr);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

_livr2.default.Validator.defaultAutoTrim();

var Form = function (_Widget) {
    _inherits(Form, _Widget);

    function Form() {
        _classCallCheck(this, Form);

        return _possibleConstructorReturn(this, (Form.__proto__ || Object.getPrototypeOf(Form)).apply(this, arguments));
    }

    _createClass(Form, [{
        key: 'start',
        value: function start(options) {
            var _this2 = this;

            if (!options.form) throw new Error('not found form');
            this.form = document.querySelector(options.form);
            this.url = options.url;

            this.optionalFields = [];
            this.defaultFields = [];

            this.defaultRules = {};
            this.optionalRules = {};

            this.confirmButton = this.form.querySelector('button[type="submit"]');

            if (options.captcha) {
                this.form.querySelector('#renewCaptcha').addEventListener('click', function (e) {
                    return _this2.renewCaptcha(e);
                });
            }

            this.successUrl = options.successUrl ? options.successUrl : '/mlogin';

            if (this.confirmButton) this.confirmButton.addEventListener('click', function (e) {
                return _this2.submitForm(e);
            });

            if (options.optional) {
                [].concat(_toConsumableArray(this.form.querySelectorAll('input[name=' + options.optionalControl + ']'))).map(function (input) {
                    return input.addEventListener('change', function (_ref) {
                        var target = _ref.target;
                        return _this2.toggleOptional(target.value === '1');
                    });
                });
            }

            this.getFields();
        }
    }, {
        key: 'toggleOptional',
        value: function toggleOptional(show) {
            var _this3 = this;

            this.resetErrors();
            this.optionalRules = {};

            this.optionalFields.map(function (field) {
                field.classList.toggle('optional--active');
                if (field.dataset.validation && show) _this3.addRule(field.getAttribute('name'), field.dataset.validation, true);
            });
        }
    }, {
        key: 'submitForm',
        value: function submitForm(e) {
            e.preventDefault();

            this.resetErrors();

            var values = this.getValues();

            var validator = this.getValidator(Object.assign({}, this.defaultRules, this.optionalRules));

            var valid = validator.validate(values);

            if (valid) {
                var submitData = window.Object.assign({}, values, valid);
                this.sendData(submitData);
            } else {
                this.handleValidationErrors(validator.getErrors());
            }
        }
    }, {
        key: 'sendData',
        value: function sendData(data) {
            var _this4 = this;

            (0, _axios2.default)({
                url: this.url,
                method: 'post',
                data: data,
                transformRequest: [function (data) {
                    var form = new FormData();
                    for (var formItem in data) {
                        form.append(formItem, data[formItem]);
                    }
                    return form;
                }]
            }).then(function (_ref2) {
                var data = _ref2.data;

                if (data.valid) {
                    return location.href = _this4.successUrl;
                } else {
                    _this4.handleValidationErrors(data.errors);
                }
            }).catch(function (err) {
                return console.log(err);
            });
        }
    }, {
        key: 'getFields',
        value: function getFields() {
            var _this5 = this;

            this.fields = this.form.querySelectorAll('input[type=text], input[type=password], input[type=checkbox], input[type=radio], input[type=hidden]');

            var fields = this.form.querySelectorAll('input[type=text], input[type=password], input[type=checkbox], input[type=radio], input[type=hidden]');[].concat(_toConsumableArray(fields)).map(function (field) {
                if (!field.dataset.optional) {
                    _this5.defaultFields.push(field);
                    if (field.dataset.validation) {
                        _this5.addRule(field.getAttribute('name'), field.dataset.validation);
                    }
                } else {
                    _this5.optionalFields.push(field);
                }
            });
        }
    }, {
        key: 'addRule',
        value: function addRule(name, rules) {
            var optional = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

            if ((typeof rules === 'undefined' ? 'undefined' : _typeof(rules)) !== 'object') rules = JSON.parse(rules);

            if (optional) return this.optionalRules = window.Object.assign({}, this.optionalRules, _defineProperty({}, name, rules));

            this.defaultRules = window.Object.assign({}, this.defaultRules, _defineProperty({}, name, rules));
        }
    }, {
        key: 'getValidator',
        value: function getValidator(rules) {
            return new _livr2.default.Validator(rules);
        }
    }, {
        key: 'getValues',
        value: function getValues() {
            var values = {};

            [].concat(_toConsumableArray(this.fields)).map(function (field) {
                if (field.getAttribute('type') === 'checkbox') {
                    return values[field.getAttribute('name')] = field.checked ? 1 : '';
                }

                if (field.getAttribute('type') === 'radio') {
                    if (!field.checked) {
                        return;
                    }

                    return values[field.getAttribute('name')] = field.value;
                }

                values[field.getAttribute('name')] = field.value;
            });

            return values;
        }
    }, {
        key: 'handleValidationErrors',
        value: function handleValidationErrors(errors) {
            var fields = {};

            var errorsI18n = {
                'WRONG_EMAIL': 'Неправильный email адрес',
                'TOO_SHORT': 'Слишком короткий пароль',
                'REQUIRED': 'Необходимо заполнить поле',
                'not.correct': 'Неправильный логин или пароль',
                'not.unique': 'Такой email уже зарегистрирован',
                'match': 'Пароль и подтверждение не совпадают'
            };[].concat(_toConsumableArray(this.fields)).map(function (field) {
                fields[field.getAttribute('name')] = field;
            });

            for (var error in errors) {
                var errorElement = window.document.createElement('span');
                errorElement.classList.add('error');
                errorElement.style.color = 'red';

                if (errorsI18n[errors[error]]) {
                    errorElement.innerHTML = errorsI18n[errors[error]];
                } else {
                    errorElement.innerHTML = errors[error];
                }

                fields[error].parentNode.insertBefore(errorElement, fields[error]);
                fields[error].style.border = '2px solid red';
            }

            var y = this.form.querySelector('.error').scrollTop;
            window.scrollTo(0, y);
            this.renewCaptcha();
        }
    }, {
        key: 'resetErrors',
        value: function resetErrors() {
            [].concat(_toConsumableArray(this.form.querySelectorAll('.error'))).map(function (error) {
                return error.remove();
            });[].concat(_toConsumableArray(this.form.querySelectorAll('input'))).map(function (input) {
                return input.style.border = '2px solid #9CC6EE';
            });
        }
    }, {
        key: 'renewCaptcha',
        value: function renewCaptcha() {
            var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

            if (e) e.preventDefault();

            this.form.querySelector('.captcha input[type=text]').value = '';
            this.form.querySelector('.captcha img').src = '/captcha?rnd=' + Math.random();
        }
    }]);

    return Form;
}(_Widget3.default);

exports.default = Form;

/***/ })

});