import Cart from './Cart'
import WidgetFactory from './WidgetFactory'

document.addEventListener('DOMContentLoaded', () => {
    const cart = new Cart()
    const widgetFactory = new WidgetFactory();
    widgetFactory.initWidgets()

    $(document).ready(function () {

        $('.date').mask('00/00/0000', {clearIfNotMatch: true});
        $('.phone').mask('(000) 000-0000', {clearIfNotMatch: true});

        /* Переключение radio-button и проверка на валидность формы для страниц login, password, recovery, registration */
        //
        // $(".radio-button").click(function () {
        //     var el = $(this),
        //         id = el.parent().attr('id'),
        //         checked = $("[id = '" + id + "'] [data-checked]");
        //     if (!checked.is(el)) {
        //         checked.removeAttr("data-checked", "checked");
        //     }
        //     el.attr("data-checked", "checked");
        // });

        // $("form").submit(function (event) {
        //     if (!!$("#agreement").length && !$("#agreement span").attr("data-checked")) {
        //         $("#label-agreement").removeClass("hide");
        //         event.preventDefault();
        //     } else {
        //         $("#label-agreement").addClass("hide");
        //     }
        //
        //     $("input[type='text']").each(function (i) {
        //         if (!this.value && this.labels[0]) {
        //             this.labels[0].className = "description show error";
        //             event.preventDefault();
        //         } else if (this.value && this.labels[0]) {
        //             this.labels[0].className = "hide";
        //         }
        //     })
        // });

        if($("#map").length > 0){
            ymaps.ready(function(){
                var c = [55.7522200, 37.6155600];
                var zoom = 10;
                if(window.library){
                    c = [library.lat, library.lon];
                    zoom = 16;
                }
                var myMap = new ymaps.Map("map", {center: c, zoom: zoom});
                myMap.behaviors.disable('scrollZoom');
                var objectManager = new ymaps.ObjectManager({clusterize: true, gridSize: 64});

                objectManager.objects.options.set('preset', 'islands#darkBlueDotIcon');
                objectManager.clusters.options.set('preset', 'islands#darkBlueClusterIcons');
                myMap.geoObjects.add(objectManager);
                var url = "/map/json";
                if($("#map").data("url")){
                    url = $("#map").data("url");
                }
                $.ajax({url: url}).done(function(data) {
                    objectManager.add(data);
                    if(window.library && !window.library.showClosed){
                        objectManager.objects.balloon.open(window.library.id);

                    }
                });
            });
        }

        $('#name_search').attr("placeholder", "Поиск по автору");

        var searchParams = {}

        $('#name_search').autocomplete({
            source: function (request, response) {
                var self = $(this);
                $.ajax(`/books/author/?term=${request.term}`, {})
                    .done(function (res) {
                        return response(res)
                    })
            },
            select: function (event, ui) {
                event.preventDefault();
                event.target.value = ui.item.label;
                searchParams.author = ui.item.label;
            }
        })
        if ($('#library_search').length) {
            $('#library_search').autocomplete({
                source: window.libraries,
                select: function (event, ui) {
                    event.preventDefault();
                    event.target.value = ui.item.label;
                    searchParams.library = ui.item.value;
                }
            }).autocomplete('instance')._renderItem = function (ul, item) {
                return $('<li>').append(`<div> ${item.label} <br> ${item.address}</div>`).appendTo(ul);
            }
        }
        if (window.library) {
            const [{label}, ...rest] = [...libraries.filter(_library => _library.value === library)]

            if (label) {
                $('#library_search').val(label)
                searchParams = Object.assign(searchParams, {library})
            }
        } else {
            $('#library_search').attr("placeholder", "Выберите библиотеку");
        }

        $('#theme_search').attr("placeholder", "Выберите тематику");

        $('#theme_search').selectmenu({
            classes: {
                'ui-selectmenu-button': 'select-button',
                'ui-selectmenu-text': 'select-text'
            },
            icons: {
                button: 'ui-icon-select'
            },
            width: null
        });

        $('#age_search').attr("placeholder", "Выберите возрастную категорию");

        $('#age_search').selectmenu({
            classes: {
                'ui-selectmenu-button': 'select-button',
                'ui-selectmenu-text': 'select-text'
            },
            icons: {
                button: 'ui-icon-select'
            },
            width: null
        });

        $('#type_search').attr("placeholder", "Выберите тип документа");

        $('#type_search').selectmenu({
            classes: {
                'ui-selectmenu-button': 'select-button',
                'ui-selectmenu-text': 'select-text'
            },
            icons: {
                button: 'ui-icon-select'
            },
            width: null
        });

        $('#metro_search').selectmenu({
            classes: {
                'ui-selectmenu-button': 'select-button',
                'ui-selectmenu-text': 'select-text'
            },
            icons: {
                button: 'ui-icon-select'
            },
            width: null
        });


        /* Главное меню */
        $(".header_menu").click(function () {
            $(".menu").toggleClass("show");
        });

        $(document).click(function (e) {
            var menu = $(".menu"),
                header_menu = $(".header_menu");
            if (!menu.is(e.target) && !header_menu.is(e.target)) {
                menu.removeClass("show");
            }
        });

        function search(e) {
            e.preventDefault()
            makeQuery(searchParams)
        }

        function makeQuery(params) {
            const authorInput = $('#name_search').val();
            const titleInput = $('#book_search').val();

            var query = '';

            if(authorInput && params.author !== authorInput) {
                params.author = authorInput
            }

            if (titleInput) {
                query += '?title='+titleInput
            }

            if (params.author) {
                if (!query) {
                    query += '?' + $.param({author: params.author})
                } else {
                    query += '&' + $.param({author: params.author})
                }

                params.author = null;
            }

            // Here params goes like [age, category, type, metro] but works only if set like [category, age, type, metro] //
            const [category, age, type, metro] = [...$('#age_search, #theme_search, #type_search, #metro_search')]
            params = Object.assign(params,  {age: age.value}, {category: category.value}, {type: type.value}, {metro: metro.value})

            var url = ''



            for (let param in params) {
                if (params[param] && params[param] !== '0')
                    url += `${param}/${params[param]}/`
            }

            if (query) {
                url += query;
            }

            if (url) {
                window.location = `/books/${url}`
            }
        }

        $('#bookSearchButton').on('click', search);
    });
})