import axios from 'axios'
import qs from 'qs'

import Widget from '../Widget'

export default class Order extends Widget {
    start(options) {
        this.container = document.querySelector(options.container)
        this.orderItems = this.container.querySelectorAll('.order__item');
        this.extendItems = this.container.querySelectorAll('.order__extend');

        [...this.extendItems].map(extend => extend.addEventListener('click', e => {
            this.extend(e.target.dataset.orderId)
            return false;
        }));

        [...this.orderItems].map(order => order.addEventListener('click', e => {
                this.loadOrder(e.target, e.target.dataset.order);
            }
        ));
    }

    loadOrder(elem, orderId) {
        if (orderId) {
            axios.get(`/order/load/${orderId}`)
                .then(response => {
                    const insert = document.createElement('div')
                    insert.innerHTML = response.data;
                    const container = elem.querySelector('.content')
                    container.innerHTML = '';
                    container.appendChild(insert.querySelector('.loaded'))
                })
                .catch(err => console.log(err))
        }
    }

    extend(id) {
        console.log(id)
        axios.post(`/order/extend`, qs.stringify({id: id})).then(data => window.location.reload())
    }

}