<?php

class App
{
    public $controller;

    public $serverName;

    public $device;

    public $viewsFolder = 'desktop';

    public static $instance;

    public function __construct()
    {
        self::$instance = $this;
        Session_Session::start();
        Db_Dao::$db = new Db_Mysql_Adapter();
        Config::getInstance()->server = $this->serverName = $_SERVER['SERVER_NAME'];
        $authClass = 'Auth_Auth';
        if (Config::getInstance()->authClass) {
            $authClass = Config::getInstance()->authClass;
        }
        new $authClass();
        if (Config::getInstance()->initDB) {
            Db_Dao::$db->initDataBase();
        }
        Route_Router::match();
        $this->device = new Mobile_Detect;
    }

    public function go()
    {
        try {
            $this->doAll();
        } catch (Exception $e) {
            if ($e instanceof PageNotFoundException) {
                header("HTTP/1.0 404 Not Found");
                $this->renderOtherController('Error', 'error');
            }
            if ($e instanceof Auth_AccessDeniedException) {
                $address = "/login";
                if (Route_Router::getZone()) {
                    $address = '/'.Route_Router::getZone().$address;
                }
                AppController::navigate($address);
            }
        }
    }

    protected function renderOtherController($name, $action = 'index')
    {
        $this->instantiateController($name, $action);
    }

    protected function doAll()
    {
        $config = Config::getInstance();
        $controller = $this->getControllerName(Route_Router::$route['controller']);
        $action = Route_Router::$route['action'];
        /**
         * Init the Mobile Detection Class
         */
        if (! file_exists('controller/'.$controller.'Controller.php')) {
            $controller = ucfirst($config->defaultController);
            $action = 'index';
        }
        $this->instantiateController($controller, $action);
    }

    protected function getControllerName($url)
    {
        $parts = explode('-', $url);
        foreach ($parts as $i => $part) {
            $parts[$i] = ucfirst($part);
        }

        return join('', $parts);
    }

    protected function getActionName($url)
    {
        $parts = explode('-', $url);
        foreach ($parts as $i => $part) {
            if ($i > 0) {
                $parts[$i] = ucfirst($part);
            }
        }

        return join('', $parts);
    }

    protected function instantiateController($name, $action)
    {
        Route_Router::$route['action'] = $action;
        Route_Router::$route['controller'] = strtolower($name);
        $clazz = $name.'Controller';
        if (! Loader::checkClassExistance($clazz)) {
            throw new PageNotFoundException('Controller '.$clazz.' Not Found');
        }
        $this->controller = new $clazz();
        $this->controller->route = Route_Router::$route;
        $methodName = $this->getActionName($action);
        if (! method_exists($this->controller, $methodName)) {
            throw new PageNotFoundException('Action Not Found');
        }
        $view = View_View::getInstance();
        $view->sessionid = Session_Session::$id;
        $view->server = $this->serverName;
        $view->currentUser = Auth_Auth::getUser();
        $this->controller->before();

        if($this->device->isMobile()) {
            $this->controller->mobile = true;
        }

        if (isset(Route_Router::$route['stop'])) {
            return;
        }
        $isForm = $this->detectFormMethod($methodName);
        if ($isForm) {
            $this->controller->$methodName($this->filterFormData());
        } else {
            $this->controller->$methodName();
        }
        $this->controller->after();
        if (! $this->controller->output) {
            return;
        }
        if ($isForm) {
            $this->processFormResult();
        } else {
            $this->processResult();
        }
    }

    protected function detectFormMethod($methodName)
    {
        if ($methodName == 'form') {
            return true;
        }
        $m = new ReflectionMethod(get_class($this->controller), $methodName);

        return $m->getNumberOfParameters() > 0;
    }

    protected function processResult()
    {
        $viewInstance = View_View::getInstance();

        $viewInstance->layout = $this->controller->layout;

        if ($this->device->isMobile() && Route_Router::$route['controller'] !== 'librarian') {
            $viewInstance->setViewsFolder('views/mobile');
            $viewInstance->layout = 'site';
        }

        //View_View::getInstance()->layout = $this->controller->layout;
        if ($this->controller->template != null && strstr($this->controller->template, '/') === false) {
            $this->controller->template = Route_Router::$route['controller'].'/'.$this->controller->template;
        }

        if ($this->controller->partial == null) {
            $this->controller->partial = Route_Router::$route['action'];
        }

        if (strstr($this->controller->partial, '/') === false) {
            $this->controller->partial = Route_Router::$route['controller'].'/'.$this->controller->partial;
        }

        $viewInstance->template = $this->controller->template;
        $viewInstance->partial = $this->controller->partial;
        $this->processOutput();
        echo $viewInstance->render();
    }

    protected function processOutput()
    {
    }

    protected function processFormResult()
    {
        self::setJsonHeaders();
        echo json_encode($this->controller->formResponse);
    }

    protected function filterFormData()
    {
        $result = [];
        $slashesAdded = get_magic_quotes_gpc() == 1;
        foreach ($_POST as $key => $value) {
            if ($slashesAdded) {
                $value = stripslashes($value);
            }
            if ($value === "false") {
                $value = 0;
            }
            if ($value === "true") {
                $value = 1;
            }
            $result[$key] = $value;
        }

        return $result;
    }

    public static function setNoCahceHeaders()
    {
        header("Pragma: no-cache");
        header("Cache-Control: no-cache");
        header("Expires: Tue, 01 Jan 1981 01:00:00 GMT");
    }

    public static function setXMLHeaders()
    {
        header("Content-Type: text/xml; charset=utf-8");
    }

    public static function setJsonHeaders()
    {
        header("Content-Type: application/json; charset=utf-8");
    }
}

?>