<?php
class Loader
{
	public static function loadClass($name)
	{
		if(self::checkClassExistance($name))
			return;
		@include_once self::getFileName($name);
		if(!self::checkClassExistance($name))
			@include_once self::getFileName($name, false);
		if(!self::checkClassExistance($name))
			throw new Exception('class '.$name.'.php has not been found');
	}
	
	public static function addToPath($newPaths)
	{
		$paths = array(get_include_path());
		if(is_array($newPaths))
			$paths = array_merge($paths, $newPaths);
		else
			$paths[] = $newPaths;
		set_include_path(implode(PATH_SEPARATOR, $paths));
	}
  
	public static function setPath($newPaths)
	{
		$paths = array();
		if(is_array($newPaths))
			$paths = array_merge($paths, $newPaths);
		else
			$paths[] = $newPaths;
		set_include_path(implode(PATH_SEPARATOR, $paths));
	}
	
	public static function checkClassExistance($name)
	{
		return class_exists($name) || interface_exists($name);
	}
	
	private static function getFileName($name, $tolower = true)
	{
		$parts = explode('_', $name);
		$index = strrpos($name, '_');
		if($index === false)
			return $name.'.php';
		$className = substr($name, $index + 1, strlen($name));
		$name = substr($name, 0, $index + 1);
		if($tolower)
			$name = strtolower($name);
		return str_replace('_', DIRECTORY_SEPARATOR, $name) . $className . '.php';
	}
}

function __autoload($name){
	Loader::loadClass($name);
}
?>