<?php
class Auth_Auth
{
	const cookieVar = 'knigisession';
	
	const sessionVar = 'user';
	
	protected $userDao;
	
	protected static $instance;
	
	private $user = null;
	
	public static function getUser()
	{
		return self::$instance->user;
	}
	
	public static function invaidateUser()
	{
		return self::$instance->user = null;
	}
	
	public function __construct()
	{
		if(Config::getInstance()->useLogin)
		{
			$this->userDao = new User_Dao();
			$this->getCreditails();
			if($this->user == null)
				$this->getRememberUser();
			self::$instance = $this;
		}
	}
	
	public static function addCookie($login, $password)
	{
		setcookie(self::$instance->getCookieVar(), $login . ';' . $password, time() + 10000 * 3600, '/', self::getDomain());
	}
	
	public static function getDomain()
	{
		$domain = str_replace('www.', '', $_SERVER['SERVER_NAME']);
		return '.' . $domain;
	}
	
	public static function deleteCookie()
	{
		setcookie(self::$instance->getCookieVar(), '', time() - 1000 * 3600, '/', self::getDomain());
	}
	
	protected function getCreditails()
	{
		$user = Session_Session::getData($this->getSessionVar());
		if($user != null)
			$user = $this->getUserData($user->login, $user->password);
		$this->user = $this->checkUser($user);
	
	}
	
	protected function getRememberUser()
	{
		if( ! isset($_COOKIE[$this->getCookieVar()]))
			return;
		$loginPassword = explode(';', $_COOKIE[$this->getCookieVar()]);
		$this->user = $this->checkUser($this->getUserData($loginPassword[0], $loginPassword[1]));
		Session_Session::setData($this->getSessionVar(), $this->user);
	}
	
	protected function getUserData($login, $password)
	{
		return $this->userDao->getByLoginAndPassword($login, $password);
	}
	
	protected function checkUser($user)
	{
		if($user == null || ($user->isblocked && $user->login != Config::getInstance()->superUserLogin))
			return null;
		return $user;
	}
	
	public static function storeUser($user, $remember = false)
	{
		Session_Session::setData(self::$instance->getSessionVar(), $user);
		if($remember)
			self::addCookie($user->login, $user->password);
		else
			self::deleteCookie();
	}
	
	public static function removeAuth()
	{
		self::deleteCookie();
		Session_Session::unsetData(self::$instance->getSessionVar());
	}
	
	public function getCookieVar()
	{
		return self::cookieVar;
	}
	
	public function getSessionVar()
	{
		return self::sessionVar;
	}
}
?>