<?php
abstract class AppController
{
	
	public static $instance = null;
	
	public $output = true;
	
	public $layout = null;
	
	public $template = null;
	
	public $partial = null;

	public $mobile = false;

	public $formResponse;
	
	public $route;
	
	protected $view;
	
	public function __construct()
	{
	    $this->formResponse = new stdClass();
		$this->formResponse->valid = true;
		$this->formResponse->errors = array();
		$this->formResponse->data = array();
		self::$instance = $this;
		$this->view = View_View::getInstance();
	}
	
	public function index()
	{
	}
	
	public function error()
	{
		
	}
	
	public function before()
	{
		
	}
	
	public function after()
	{
	}
	
	public static function navigate($address)
	{
		if(self::$instance != null)
			self::$instance->output = false;
		header("location: ".$address);
	}
	
	public function form($data)
	{
		
	}
	
	protected function addFormError($field, $error)
	{
		$this->formResponse->errors[$field] = $error;
		$this->formResponse->valid = false;
	}
	
	protected function addFormData($name, $value)
	{
		$this->formResponse->data[$name] = $value;
	}
	
	protected function formIsValid()
	{
		return $this->formResponse->valid;
	}
	
	protected function parsePage($name = 'page', $max = 0)
	{
		$page = 0;
		if(is_numeric($name))
		{
			$max = $name;
			$name = 'page';
		}
		if(isset(Route_Router::$route[$name]))
			$page = intval(Route_Router::$route[$name]) - 1;
		if($page < 0 || ($page > $max && $max > 0))
			$page = 0;
		return $page;
	}
	
	public function &__get($field)
	{
		return $this->view->$field;
	}
	
	public function __set($field, $value)
	{
		$this->view->$field = $value;
	}
	
	public static function noCache(){
		header("Pragma: no-cache");
		header("Cache-Control: no-cache");
		header("Expires: Tue, 01 Jan 1981 01:00:00 GMT");
	}
	
	public static function xmlHeaders($noCahe = false)
	{
		header("Content-Type: text/xml; charset=utf-8");
		if($noCahe){
			self::noCache();
		}
	}
	
	public static function jsonHeaders($noCahe = false)
	{
		header("Content-Type: application/json; charset=utf-8");
		if($noCahe){
			self::noCache();
		}
	}
}
?>