<?php
class Article_Dao extends Tree_Dao 
{
	public $model = 'Article_Article';
	
	public $table = "articles";
	
	public function getByOtherUrl($url, $admin = false)
	{
		$criteria = Db_Criteria::create(array('otherurl' => $url));
		if (!$admin)
			$criteria->add(array('published = 1'));
		return parent::one($criteria);
	}

	public function beforeInsert(&$values)
	{
		parent::beforeInsert($values);
		$values['otherurl'] = '';
		$values['name'] = '';
		$values['title'] = '';
		$values['descr'] = '';
		$values['text'] = '';
	}
	
	public function beforeUpdate($id, $values)
	{
		if (isset($values['def']) && $values['def'] == 1)
			$this->updateByCriteria(Db_Criteria::create('1 = 1'), array('def' => 0));
	}
	
	public function getArticle($id, $admin = false, $fields = array())
	{
		return parent::getNode($id, $admin, $fields);
	}

	public function getDefault()
	{
		return parent::one(Db_Criteria::create(array('published = 1', 'def = 1')));
	}
}
?>