<?php
class Catalog_Dao extends Db_Dao
{
	public $model = 'Catalog_Field';
	
	public $table = "catalogitems";
	
	public function deleteAllInCategory($categoryId)
	{
		$this->deleteByCriteria(Db_Criteria::create(array('category' => $categoryId)));
	}
	
	public function getByArticul($articul)
	{
		return $this->one(Db_Criteria::create(Db_Exp::eq('articul', $articul, true)));
	}
	
	public function beforeInsert(&$values)
	{
		$values['gallery_id'] = Db_Dao::dao('Photo_Gallery_Dao')->insert();
	}
	
	public function publish($id)
	{
		return $this->update($id, array('published'=>(1 - $this->get($id)->published)));
	}
}
?>