<?php
class Image_Dao extends Db_Dao
{
	public $model = 'Image_Image';
	
	public $table = 'image';
	
	private $resizer;
	
	public $folder = '/uploads/images/';
	
	public $srcFolder = '/uploads/originals/';
	
	public $tmpFolder = '/uploads/tmp/';
	
	public $file = 'flashfile';
	
	private $originalResize;
	
	private $type = 'jpg';
	
	public function __construct()
	{
		parent::__construct();
		$this->folder = SITE_DIR . (Config::getInstance()->imageFolder != null ? Config::getInstance()->imageFolder : $this->folder);
		$this->srcFolder = SITE_DIR . (Config::getInstance()->imageSrcFolder != null ? Config::getInstance()->imageSrcFolder : $this->srcFolder);
		$this->tmpFolder = SITE_DIR . (Config::getInstance()->imageTmpFolder != null ? Config::getInstance()->imageTmpFolder : $this->tmpFolder);
		$this->resizer = new Image_Resizer();
		$this->originalResize = new Image_Resize(0, 0, Image_Format::ENCODE);
	}
	
	public function upload($slice)
	{
		if(!$slice)
			throw new Exception('slice not found');
		$imageId = $this->insert();
		if(!$imageId)
			return null;
		if(Config::getInstance()->imageFormat)
			$this->type = Config::getInstance()->imageFormat;
		if(!isset($_FILES[$this->file]) || $_FILES[$this->file]['error'] || !$_FILES[$this->file]['tmp_name'])
			return null;
		
		$file = $_FILES[$this->file]['tmp_name'];
		$tmpName = $this->tmpFolder . md5($file);
		if(!move_uploaded_file($file, $tmpName))
			return null;
		
		$info = $this->resizer->resize($this->originalResize, $imageId, $tmpName, $this->srcFolder, $this->type);
		if($info == null)
			$this->delete($imageId);
		else
			$this->update($imageId, array('width'=>$info['width'], 'height'=>$info['height'], 'size'=>$info['size'], 'mime'=>$info['mime']));
		$resizeDao = new Image_Resize_Dao();
		foreach($slice as $name=>$format)
		{
			$resizeId = $resizeDao->create($imageId);
			$info = $this->resizer->resize($format, $name.$imageId, $tmpName, $this->folder, 'jpg');
			if($info == null)
				$resizeDao->delete($resizeId);
			else
				$resizeDao->update($resizeId, array('name'=>$name, 'width'=>$info['width'], 'height'=>$info['height'], 'size'=>$info['size'], 'mime'=>$info['mime']));
		}
		@unlink($tmpName);
		$this->resizer->clean();
		return $this->get($imageId);
	}
	
	public function uploadResize($image, $name)
	{
		$resizeDao = new Image_Resize_Dao();
		$resize =$resizeDao->getResize($image, $name);
		if($resize == null)
			return null;
		$newResize = $resizeDao->create($image);
		$type = 'jpg';
		if(Config::getInstance()->imageFormat)
			$type = Config::getInstance()->imageFormat;
		$info = $this->resizer->resize($this->originalResize, $name.$image->id, $this->file, $this->folder, $type);
		$newResize = $resizeDao->update(array('id'=>$newResize->id, 'name'=>$name, 'width'=>$info['width'], 'height'=>$info['height'], 'size'=>$info['size'], 'mime'=>$info['mime']));
		$resizeDao->delete($resize->id);
		$this->resizer->clean();
		return $newResize;
	}
	
	protected function beforeDelete($ids)
	{
		if(is_array($ids))
			return;
		@unlink($this->srcFolder . $image->id . '.'.$this->type);
		$resizeDao = new Image_Resize_Dao();
		$resizes = $resizeDao->getResizes($ids);
		foreach($resizes as $resize)
			@unlink($this->folder . $resize->name . $image->id . '.'.$this->type);
		$resizeDao->deleteResizes($ids);
	}
}
?>