<?php
class Image_Image extends Db_Field
{
	private $res = null;
	
	public function __get($field)
	{
		if($field == 'resizes')
			return $this->getResizes();
		return parent::__get($field);
	}
	
	public function getResizes()
	{
		if($this->res != null)
			return $this->res;
		$resizeDao = new Image_Resize_Dao();
		$resizes = $resizeDao->getResizes($this->id);
		$this->res = array();
		foreach($resizes as $resize)
			$this->res[$resize->name] = $resize;
		return $this->res;
	}
	
	public function serialize()
	{
		
		return json_encode($this->copy());
	}
	
	public function copy()
	{
		$obj = new stdClass();
		foreach($this->vars as $var => $value)
			$obj->$var = $value;
		$obj->resizes = array();
		foreach($this->resizes as $name => $resize)
		{
			$o = new stdClass();
			$o->name = $name;
			$o->id = $resize->id;
			$o->width = $resize->width;
			$o->height = $resize->height;
			$obj->resizes[$name] = $o;
		}
		return $obj;
	}
}
?>