<?php
class News_Dao extends Db_Dao
{
	public $model = 'News_Field';
	
	public $table = "news";
	
	public function create($categoryId)
	{
		return parent::insert(array('text'=>'', 'shorttext'=>'', 'title'=>'', 'pagetitle'=>'', 'keywords'=>'', 'description'=>'', 'category_id'=>$categoryId, 'date'=>date('Y-m-d')));
	}
	
	public function beforeInsert(&$values)
	{
		$values['gallery_id'] = Db_Dao::dao('Photo_Gallery_Dao')->insert();
	}
	
	public function publish($id)
	{
		return $this->update($id, array('published'=>(1 - $this->get($id)->published)));
	}
}
?>