<?php
class Presets_Dao extends Db_Dao
{
	public $table = "common";
	
	public $model = null;
	
	private static $instance;
	
	private static $cache = null;
	
	public function __construct()
	{
		self::$instance = $this;
	}
	
	public static function getPresets()
	{
		if(self::$instance == null)
			self::$instance = new Presets_Dao();
		if(self::$cache == null){
			if(Config::getInstance()->presetsCache){
				self::$cache = json_decode(Config::getInstance()->presetsCache);
			}else{
				self::$cache = json_decode(self::$instance->one()->settings);
			}
		}
		if(self::$cache == null)
			self::$cache = new Db_Field();
		return self::$cache;
	}
	
	public static function fetch($name, $default = null)
	{
		$presets = self::getPresets();
		$val = $presets->$name;
		if(!$val && $default !== null){
			$val = $default;
		}
		return $val;
	}
	
	public static function savePresets($settings)
	{
		if(self::$instance == null)
			self::$instance = new Presets_Dao();
		self::$instance->updateByCriteria(Db_Criteria::create(array("1 = 1")), array('settings' => json_encode($settings)));
	}
}
?>