<?php
class Tree_Dao extends Db_Dao 
{
	public function getByUrl($url)
	{
		return parent::one(Db_Criteria::create(array('url' => $url)));
	}
	
	public function create($parent, $fields = array())
	{
		$node = $this->insert(array('parent_id' => $parent), true);
		$level = 0;
		$code = $this->buildCode($node->id);
		if($parent != 0)
		{
			$parentNode = $this->get($parent);
			$newIndex = $parentNode->childindex + 1;
			$this->update($parentNode->id, array('childindex' => $newIndex));
			$code = $parentNode->code.'.'.$this->buildCode($newIndex);
			$level = $parentNode->level + 1;
		}
		$values = array_merge(array('code'=>$code, 'level'=>$level), $fields);
		$this->update($node->id, $values);
		return $node->id;
	}
	
	private function buildCode($index){
		$l = strlen($index.'');
		$res = $index;
		for($i = $l; $i < 4; $i++)
			$res = '0'.$res;
		return $res;
	}
	
	protected function beforeDelete($id)
	{
		parent::beforeDelete($id);
		$node = $this->get($id);
		if($node == null)
			return;
		$this->deleteByCriteria(Db_Criteria::create(Db_Exp::likeLeft('code', $node->code)));
	}
	
	public function getParentByCode($code)
	{
		$atoms = explode('.', $code);
		return $this->one(array('code', $atoms[0]));
	}
	
	public function publish($id)
	{
		return $this->update($id, array('published'=>(1 - $this->get($id)->published)));
	}
	
	public function getPath($node, $fields = null)
	{
		$result = array();
		$paths = explode('.', $node->code);
		$code = $paths[0];
		$expressions = array();
		for($i = 0; $i < count($paths) - 1; $i++)
		{
			if($i > 0)
				$code .= '.'.$paths[$i];
			$expressions[] = Db_Exp::eq('code', $code);
		}
		if(count($expressions) > 0)
			$result = $this->all(Db_Criteria::create(Db_Exp::disunction($expressions))->order(Db_Order::asc('level'))->field($fields));
		$result[] = $node;
		return $result;
	}
}

?>
