<?php
class User_Dao extends Db_Dao
{
	public $model = 'User_User';
	
	public $table = "users";
	
	private $tokenSecret = ']t"M6o&a;\I$z<cj';
	
	public function getByLogin($login)
	{
		return $this->one(new Db_Criteria(array('login' => $login)));
	}
	
	public function getByEmail($email)
	{
		return $this->one(new Db_Criteria(array('email' => $email)));
	}

    public function getByPhone($phone)
    {
        return $this->one(new Db_Criteria(array('phone' => $phone)));
    }
	
	public function getByLoginAndPassword($login, $password)
	{
		return $this->one(new Db_Criteria(array('login' => $login, 'password' => $password)));
	}
	
	public function getToken($user){
		$time = time();
		$t = md5(join('-', array($user->id, $this->tokenSecret, $time, $this->tokenSecret)));
		return join('_', array($user->id, $time, $t));
	}
	
	public function checkToken($token){
		$parts = explode('_', $token);
		if(count($parts) != 3){
			return null;
		}
		$token = md5(join('-', array($parts[0], $this->tokenSecret, $parts[1], $this->tokenSecret)));
		if($token != $parts[2]){
			return null;
		}
		return $this->get(intval($parts[0]));
	}
	
	public function register($values, $roles = null)
	{
		$values['isblocked'] = 1;
		$values['first_log_in'] = 1;
		if($roles != null)
			$values['roles'] = join(',', $roles);
		$values['registration_date'] = date('Y-m-d H:i:s');
		return $this->insert($values, true);
	}
	
	public function declineUser($user, $message){
		$data = array('email' => $user->email, 'org_name' => addslashes($user->org_name), 'token' => $this->getToken($user), 'message' => $message);
		$this->update($user->id, array('roles' => '12', 'isblocked' => '1', 'is_declined' => '1'));
		$mailDao = new Mail_Dao();
		$mailDao->add($user->email, 'decline', $data);
	}

    public function approveUser($user){
        $original_password = Util::generatePassword();
        $password = md5($original_password);
        $data = array('email' => $user->email, 'original_password' => $original_password, 'password' => $password, 'org_name' => addslashes($user->org_name), 'token' => $this->getToken($user));
        $this->update($user->id, array('password' => $password, 'isblocked' => '0', 'is_declined' => '0'));
        $mailDao = new Mail_Dao();
        $mailDao->add($user->email, 'entityconfirm', $data);
    }
	
	public function edit($values, $roles = null)
	{
		if($roles != null)
			$values['roles'] = ','.join(',', $roles).',';
		return $this->update($values);
	}

    public function delete($userId)
    {
        parent::delete($userId);
    }

	public function resetRegistrationEmail($user)
	{
        if ($user != null) {
            $mailDao = new Mail_Dao();

            if (in_array('2', $user->roles)) {
                $data['email'] = $user->email;
                $mailDao->add($user->email, 'resendreg', $data);
            }
        }
	}

    /**
     * Validating user by hash from GET
     */
	public function validateUser($hash)
    {
        $query = "UPDATE `users` SET `email_valid` = 1, `isblocked` = if (`roles` = 11 || `roles` = 12, `isblocked`, 0) WHERE `validation` = '" . $hash . "'";
        $this->sql($query);
    }
}
?>