<?php
class User_User extends Db_Field
{
	protected $references = array('image' => 'Image_Dao', 'library' => 'Library_Dao');
	
	public function __get($field)
	{
		if($field == 'roles')
			return $this->getRoles();
		return parent::__get($field);
	}
	
	private function getRoles()
	{
		return explode(',', trim($this->vars['roles'], ','));
	}
	
	public function isAdmin()
	{
		return $this->isInRole(Auth_Roles::ADMIN);
	}
	
	public function isSuperAdmin()
	{
		return $this->isInRole(Auth_Roles::SUPER_USER);
	}
	
	public function isGeneric(){
		return $this->isInRole(Roles::GENERIC);
	}
	
	public function isInRole($role)
	{
		return in_array($role, $this->getRoles());
	}
}
?>