<?php
class Db_Dao
{
	public static $db;

	public $table = null;
	
	public $model = 'Db_Field';
	
	public static $instances = array();
	
	public function __construct()
	{
		
	}
	
	public static function dao($clazz)
	{
		if(!isset(self::$instances[$clazz]))
			self::$instances[$clazz] = new $clazz();
		return self::$instances[$clazz];
	}
	
	public function getTable()
	{
		return $this->table;
	}
	
	public function setTable($table)
	{
		$this->table = $table;
	}
	
	public function get($ids)
	{
		$table = $this->resolveTable();
		$sql = "SELECT * FROM $table where id ";
		if(!$ids)
			return null;
		if(!is_array($ids)){
			$sql .= '= '.intval($ids);
			return self::$db->getUniqueData($sql, $this->model);
		}
		$sql .= 'in ('.join(',', $ids).')';
		return self::$db->getData($sql, $this->model);
	}
	
	public function one(Db_Criteria $criteria = null)
	{
		if($criteria == null)
			$criteria = Db_Criteria::create();
		if($criteria->getSql())
			return self::$db->getUniqueData($criteria->getSql(), $this->model);
		$items = $this->all($criteria->page(0)->perPage(1));
		if(!$items)
			return null;
		return $items[0];
	}
	
	public function all(Db_Criteria $criteria = null)
	{
	    if($criteria == null)
			$criteria = Db_Criteria::create();
		if($criteria->getSql())
			return self::$db->getData($criteria->getSql(), $this->model);
		$fields = $this->getSelectFields($criteria->getFields());

		$table = $this->resolveTable($criteria->getTable());
		
		if($criteria->getDistinct())
			$query = "SELECT DISTINCT $fields FROM $table";
		else if ($criteria->setBefore())
			$query = $criteria->setBefore();
        else
            $query = "SELECT $fields FROM $table";
		$conditions = $this->processCriteria($criteria->getExpressions());
		if($conditions)
			$query .= " WHERE " . $conditions;
		if($criteria->getOrders())
			$query .= " ORDER BY ".implode(', ', $criteria->getOrders());
		if($criteria->getPerPage() > 0)
		{
			if($criteria->getPage() < 0)
				$criteria->page(0);
			$query .= " LIMIT " . ($criteria->getPage() * $criteria->getPerPage()) . ", " . ($criteria->getPerPage() + $criteria->getMore());
		}
		return self::$db->getData($query, $this->model);
	}
	
	public function sql($sql)
	{
		if($sql instanceof Db_Criteria)
			self::$db->query($sql->getSql());
		else
			self::$db->query($sql);
	}
	
	public function delete($ids, $skipFilters = false)
	{
		if(!$ids)
			return;
		if(!$skipFilters)
			$this->beforeDelete($ids);
		$table = $this->resolveTable();
		$sql = "DELETE FROM $table where id ";
		if(!is_array($ids))
			$sql .= '= '.intval($ids);
		else
			$sql .= 'in ('.join(',', $ids).')';
		self::$db->query($sql);
		if(!$skipFilters)
			$this->afterDelete($ids);
	}
	
	public function deleteByCriteria(Db_Criteria $criteria = null)
	{
		if($criteria == null)
			$criteria = Db_Criteria::create();
		$conditions = $this->processCriteria($criteria->getExpressions());
		if(!$conditions)
			return;
		$table = $this->resolveTable();
		$sql = "DELETE FROM $table WHERE $conditions";
		self::$db->query($sql);
	}
	
	public function save($ids, $values)
	{
		$this->update($ids, $values);
	}
	
	public function update($ids, $values, $skipFilters = false)
	{
		if(isset($values['id']))
			unset($values['id']);
		if(!$ids || !$values)
			return;
		if(!$skipFilters)
			$this->beforeUpdate($ids, $values);
		$table = $this->resolveTable();
		$fields = [];
		foreach($values as $key => $value)
		{
			if($key == "id")
				continue;
			$fields[] = "$key = " . Db_Exp::prepareValue($value);
		}
		if(is_array($ids))
			$query = "UPDATE $table SET ".join(', ', $fields) . " WHERE `id` in (".join(', ', $ids).")";
		else
			$query = "UPDATE $table SET ".join(', ', $fields) . " WHERE `id` = ".intval($ids);
		self::$db->query($query);
		if(!$skipFilters)
			$this->afterUpdate($ids, $values);
	}
	
	public function updateByCriteria(Db_Criteria $criteria = null, $values = null)
	{
		if(!$criteria)
			return;
		$conditions = $this->processCriteria($criteria->getExpressions());
		if(!$conditions)
			return;
		$table = $this->resolveTable($criteria->getTable());
		$fields = [];
		foreach($values as $key => $value)
		{
			if($key == "id")
				continue;
			$fields[] = "$key = " . Db_Exp::prepareValue($value);
		}
		$query = "UPDATE $table SET ".join(', ', $fields) . " WHERE $conditions";
		self::$db->query($query);
	}
	
	public function count(Db_Criteria $criteria = null)
	{
		if($criteria == null)
			$criteria = Db_Criteria::create();
		$var = "count(*)";
		if($criteria->getDistinct())
			$var = 'count(DISTINCT '.$criteria->getDistinct().')';
		$conditions = $this->processCriteria($criteria->getExpressions());
		if($conditions)
			$conditions = "WHERE $conditions";
		$table = $this->resolveTable($criteria->getTable());
		$result = self::$db->getUniqueData("SELECT $var as c FROM {$table} $conditions");
		return $result->c;
	}
	
	public function insert($values = array(), $returnObject = false, $skipFilters = false)
	{
		$names = array();
		$vals = array();
		$table = $this->resolveTable();
		if(!$skipFilters)
			$this->beforeInsert($values);
		foreach($values as $key => $value)
		{
			$names[] = $key;
			$vals[] = Db_Exp::prepareValue($value);
		}
		$sql = "INSERT INTO $table (" . join(', ', $names) . ") VALUES (" . join(', ', $vals) . ")";
		$id = self::$db->insert($sql);
		if(!$skipFilters)
			$this->afterInsert($id, $values);
		if($id == null)
			return null;
		if(!$returnObject)
			return $id;
		return $this->get($id);
	}
	
	protected function getSelectFields($fields){
		if(count($fields) > 0)
			return join(', ', $fields);
		return "*";
	}
	
	protected function processCriteria($criteria)
	{
		return join(' AND ', $criteria);
	}
	
	protected function resolveTable($table = null)
	{
		return self::$db->prefix . ($table ? $table : $this->table);
	}
	
	protected function beforeDelete($ids){}
	
	protected function afterDelete($ids){}
	
	protected function beforeUpdate($ids, &$values){}
	
	protected function afterUpdate($ids, &$values){}
	
	protected function beforeInsert(&$values){}
	
	protected function afterInsert($id, &$values){}
}
?>
