<?php

class Db_Field
{
	protected $vars = array();
	
	protected $references = array();
	
	protected $cache = array();
	
	public function __set($f, $v)
	{
		$this->vars[$f] = is_string($v) ? stripslashes($v) : $v;
	}
	
	public function __get($field)
	{
		if(!isset($this->vars[$field]) && isset($this->references[$field]))
		{
			$id_field = $field . "_id";
			if(!isset($this->vars[$id_field]) || !$this->vars[$id_field])
				return null;
			if(isset($this->cache[$field]))
				return $this->cache[$field];
			$ref = $this->references[$field];
			if(strpos($ref, 'Dao') !== false)
				$d = new $ref();
			else 
			{
				$d = new Db_Dao();
				$d->setTable($ref);
			}
			$cache[$field] = $d->get($this->vars[$id_field]);
			return $cache[$field];
		}
		if(!isset($this->vars[$field]))
			return null;
		return $this->vars[$field];
	}
	
	public function __toString()
	{
		if($this->id)
			return $this->id;
		return get_class($this);
	}
}

?>