<?php
class Db_Mysql_Adapter
{
	private $host;
	
	private $user;
	
	private $password;
	
	private $database;
	
	private $connector;
	
	public $prefix = "";
	
	public function __construct($params = null)
	{
		if($params != null)
		{
			if(isset($params['host']))
				$this->host = $params['host'];
			else
				$this->host = "localhost";
			if(isset($params['user']))
				$this->user = $params['user'];
			else
				$this->user = "root";
			if(isset($params['password']))
				$this->password = $params['password'];
			else
				$this->password = "";
			if(isset($params['database']))
				$this->database = $params['database'];
			if(isset($params['prefix']))
				$this->prefix = $params['prefix'];
		}
		else
		{
			$this->host = HOST;
			$this->user = USER;
			$this->password = PASSWORD;
			$this->database = DB_NAME;
			$this->prefix = DB_PREFIX;
		}
		$this->connect();
	}
	
	public function getData($sql, $clazz = false)
	{
        @$sect = mysqli_query( $this->connector, $sql);
	    if(!$sect)
			return null;
		if(mysqli_num_rows($sect) == 0)
			return array();
		$res = array();
		if($clazz){
			while(($obj = $sectRes = mysqli_fetch_object($sect,  $clazz)) != null)
				$res[] = $obj;
		}else{
			while(($obj = $sectRes = mysqli_fetch_object($sect)) != null)
				$res[] = $obj;
		}
		return $res;	
	}
	
	public function getUniqueData($sql, $clazz = null)
	{
		
		if($sql == '')
			return null;
		@$sect = mysqli_query( $this->connector, $sql);
		if(!$sect)
			return null;
		if(mysqli_num_rows($sect) == 0)
			return null;
		if(!$clazz)
			return mysqli_fetch_object($sect);
		return mysqli_fetch_object($sect,  $clazz);
	}
	
	public function query($sql)
	{
		if($sql == '')
			return null;
		$sect = mysqli_query( $this->connector, $sql);
		if($sect === false)
			return null;
		return true;	
	}
	
	public function insert($sql)
	{
		if($this->query($sql, $this->connector))
			return ((is_null($___mysqli_res = mysqli_insert_id($this->connector))) ? false : $___mysqli_res);
		return null;	
	}
	
	public function connect()
	{
		@$this->connector=($GLOBALS["___mysqli_ston"] = mysqli_connect($this->host,  $this->user,  $this->password));
		if(!$this->connector || !@mysqli_select_db( $this->connector, $this->database))
			die("database server connection failed");
		$this->query("set character_set_client='utf8'");
		$this->query("set character_set_results='utf8'");
		$this->query("set collation_connection='utf8_general_ci'");		
	}
	
	public function disconnect()
	{
		((is_null($___mysqli_res = mysqli_close($this->connector))) ? false : $___mysqli_res);
	}
	
	public function getTables()
	{
	    $result = array();
	    $list = @mysqli_query($GLOBALS["___mysqli_ston"], "SHOW TABLES FROM `$this->database`");
	    $n = mysqli_num_rows($list);
	    for($i = 0; $i < $n; $i++)
	        $result[] = ((mysqli_data_seek($list,  $i) && (($___mysqli_tmp = mysqli_fetch_row($list)) !== NULL)) ? array_shift($___mysqli_tmp) : false);
	    return $result;
	}
	
	public function escape($str)
	{
		if(is_numeric($str))
			return $str;
		return mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $str);
	}
	
	public function initDataBase()
	{
		$config = Config::getInstance();
		$tables = $this->getTables();
		$find = false;
		foreach ($config->db as $key => $value) {
			$find = false;
			foreach($tables as $table)
			{
				if ($table == $this->prefix . $key)
				{
					$find = true;
					break;
				}
			}
			if (!$find)
				$this->query(str_replace($key, $this->prefix . $key, $value));
			$this->syncColumns($key, $this->parseTable($key));
		}
		if (!$tables && $config->initQueries) 
		{
			foreach($config->initQueries as $query)
				$this->query(preg_replace('/([^`]+`)([^`]+)(`.+)/i', '\1' . $this->prefix . '\2\3', $query));
		}
	}
	
	public function parseTable($table)
	{
		$fields = array();
		$tableDefinition = Config::getInstance()->db[$table];
		$indexl = strpos($tableDefinition, '(') + 1;
		$indexr = strrpos($tableDefinition, ')');
		$tableDefinition = trim(substr($tableDefinition, $indexl, $indexr - $indexl));
		$fields = explode(",", $tableDefinition);
		$parsedFields = array();
		foreach($fields as $field)
		{
			$field = trim($field);
			if(stripos($field, 'primary') !== false || stripos($field, 'unique') !== false)
				continue;
			$fieldName = substr($field, 0, strpos($field, ' '));
			$field = trim(str_replace($fieldName, "", $field));
			$fieldName = trim(str_replace('`', '', $fieldName));
			$attributes = '';
			if(stripos($field, "auto_increment"))
			{
				$attributes = 'auto_increment';
				$field = str_ireplace('auto_increment', '', $field);
			}
			$default = null;
			$defaultIndex = stripos($field, 'default');
			if($defaultIndex)
			{
				$defaultSub = trim(substr($field, $defaultIndex + 7, strlen($field)));
				if($defaultSub[0] == '"' || $defaultSub[0] == '\'')
				{
					$default = substr($defaultSub, 0, strpos($defaultSub, $defaultSub[0], 1) + 1);
				}
				else
				{
					$endIndex = strpos($defaultSub, ' ');
					if($endIndex)
						$default = substr($defaultSub, 0, $endIndex);
					else
						$default = $defaultSub;
					if(strtolower($default) == 'null')
						$default = null;
				}
				$defaultSub = trim(str_ireplace(array('default', $default), '', $defaultSub));
				$field = trim(str_ireplace(substr($field, $defaultIndex, strlen($field)), $defaultSub, $field));
			}
			$null = true;
			if(stripos($field, "NOT NULL"))
			{
				$null = false;
				$field = str_ireplace('NOT NULL', '', $field);
			}
			if(stripos($field, "NULL"))
			{
				$null = true;
				$field = str_ireplace('NULL', '', $field);
			}
			$type = str_replace(' ', '', $field);
			
			$parsedFields[$fieldName] = array(
				'type' => $type,
				'null' => $null,
				'default' => $default,
				'attributes' => $attributes
			);
		}
		return $parsedFields;
	}
	
	protected function syncColumns($table, $parsedFields)
	{
		$dbDefinition = $this->getData("describe $this->prefix$table");
		$dbFields = array();
		foreach($dbDefinition as $field)
			$dbFields[$field->Field] = $field;
		foreach($parsedFields as $field => $attributes)
		{
			if(!isset($dbFields[$field]))
			{
				$this->addColumn($table, $field, $attributes['type'], $attributes['null'], $attributes['default']);
			}
			elseif(!$this->compare($attributes, $dbFields[$field]))
				$this->changeColumn($table, $field, $attributes['type'], $attributes['null'], $attributes['default']);
		}
		foreach($dbFields as $field => $attributes)
		{
			if(!isset($parsedFields[$field]))
				$this->removeColumn($table, $field);
		}
	}
	
	private function compare($field, $dbField)
	{
		$dbf = $this->convertDbFieldToOur($dbField);
		if($field['null'] !== $dbf['null'])
			return false;
		if(strpos($dbf['type'], '(') == false || strpos($field['type'], '(') == false)
		{
			$dbf['type'] = preg_replace('/\(\d+\)/', '', $dbf['type']);
			$field['type'] = preg_replace('/\(\d+\)/', '', $field['type']);
		}
		if($field['type'] !== $dbf['type'])
			return false;
		if($field['default'] !== $dbf['default'])
			return false;
		return true;
	}
	
	private function convertDbFieldToOur($dbField)
	{
		$field = array('null' => $dbField->Null == 'YES', 'type' => $dbField->Type);
		$default = null;
		if(!is_null($dbField->Default))
			$default = $dbField->Default;
		$field['default'] = $default;
		return $field;
	}
	
	private function addColumn($table, $field, $type, $null, $default)
	{
		$sql = "alter table `$this->prefix$table` add $field $type";
		if($null)
			$sql .= " NULL";
		else
			$sql .= " NOT NULL";
		if($default !== null)
			$sql .= " DEFAULT $default";
		$this->query($sql);
	}
	
	private function changeColumn($table, $field, $type, $null, $default)
	{
		$sql = "alter table `$this->prefix$table` change `$field` `$field` $type";
		if($null)
			$sql .= " NULL";
		else
			$sql .= " NOT NULL";
		if($default !== null)
			$sql .= " DEFAULT $default";
		$this->query($sql);
	}
	
	private function removeColumn($table, $field)
	{
		$sql = "alter table `$this->prefix$table` drop `$field`";
		$this->query($sql);
	}
}
?>