<?php

class Image_ImageMagicResizer 
{
	public $uploaded = true;
	
	public $file_src_pathname = null;
	
	private $image_supported;
	
	private $imageInfo = null;
	
	private $convert = '/usr/bin/convert';
	
	public function __construct()
	{
		$this->image_supported = array('image/gif'=>'gif', 'image/jpg'=>'jpg', 'image/jpeg'=>'jpg', 'image/pjpeg'=>'jpg', 'image/png'=>'png', 'image/x-png'=>'png', 'image/bmp'=>'bmp', 'image/x-ms-bmp'=>'bmp', 'image/x-windows-bmp'=>'bmp');
	}
	
	public function init($file)
	{
		if(Config::getInstance()->imageMagickPath){
			$this->convert = Config::getInstance()->imageMagickPath;
		}
		
		$this->uploaded = true;
		
		if(!$file)
		{
			$this->uploaded = false;
			return;
		}
		$this->file_src_pathname = $file;
		
		if(!is_readable($this->file_src_pathname))
		{
			$this->uploaded = false;
			return;
		}
		
		$this->imageInfo = $this->getInfo($this->file_src_pathname);
		if(!$this->imageInfo['type'])
		{
			$this->uploaded = false;
			return;
		}
	}
	
	public function process($to, Image_Resize $format)
	{
		$file = $this->file_src_pathname;
		if($this->imageInfo['type'] == 'gif')
			$file = $file."[0]";
		
		if($format->format == Image_Format::ENCODE)
		{
			//error_log("$this->convert $file $to");
			exec("$this->convert $file $to");
			return;
		}
		$options = "";
		$new_w = 0;
		$new_h = 0;
		switch($format->format)
		{
			case Image_Format::DESCRIBE:
				if($this->imageInfo['width'] > $this->imageInfo['height'])
				{
					$options = "-resize x{$format->height}";
					$new_h = $format->height;
				}
				else
				{
					$options = "-resize {$format->width}x";
					$new_w = $format->width;
				}
				break;
			case Image_Format::DESCRIBE_H:
				$options = "-resize x{$format->height}";
				$new_h = $format->height;
				break;
			case Image_Format::DESCRIBE_W:
				$options = "-resize {$format->width}x";
				$new_w = $format->width;
				break;	
			case Image_Format::INSCRIBE:
				$options = "-resize {$format->width}x{$format->height}";
				break;
		}
		//if(!$format->enlarge)
		//	$options .= '\>';
		if($format->crop)
		{
			$x = 0;
			$y = 0;
			if($new_w > 0 || $new_h > 0)
			{
				if($new_w)
					$y = round(abs($format->height - $new_w / $this->imageInfo['width'] * $this->imageInfo['height']) / 2);
				else
					$x = round(abs($format->width - $new_h / $this->imageInfo['height'] * $this->imageInfo['width']) / 2);
			}
			$options .= " -crop {$format->width}x{$format->height}+$x+$y";
		}
		$options .= " -quality 90";
		//error_log("$this->convert $file $options $to");
		exec("$this->convert $file $options $to");
	}
	
	public function getInfo($file)
	{
		if(!file_exists($file))
			return null;
		$info = array();
		$info = getimagesize($file);
		$info['width'] = $info[0];
		$info['height'] = $info[1];
		$info['size'] = filesize($file);
		if(function_exists("exif_imagetype"))
		{
			$mime = exif_imagetype($this->file_src_pathname);
			if($mime == IMAGETYPE_GIF)
				$info['mime'] = "image/gif";
			if($mime == IMAGETYPE_JPEG)
				$info['mime'] = "image/jpeg";
			if($mime == IMAGETYPE_PNG)
				$info['mime'] = "image/png";
			if($mime == IMAGETYPE_BMP)
				$info['mime'] = "image/bmp";
		}
		if(empty($this->file_src_mime) && function_exists('mime_content_type'))
			$info['mime'] = "image/bmp";
		$info['type'] = $this->image_supported[$info['mime']];
		return $info;
	}
}

?>