<?php
class Image_Resizer
{
	private $uploader = null;
	
	private $resizeTool;
	
	public function __construct()
	{
		if(Config::getInstance()->useImageMagic)
			$this->resizeTool = new Image_ImageMagicResizer();
		else
			$this->resizeTool = new Utils_Image();
	}
	
	public function resize($format, $name, $file, $folder, $type = "jpg")
	{
		if(Config::getInstance()->useImageMagic)
		{
			$this->resizeTool->init($file);
			if(!$this->resizeTool->uploaded)
				return null;
			$resize = $folder . $name . '.' . $type;
			$this->resizeTool->process($resize, $format);
			return $this->resizeTool->getInfo($resize);
		}
		$this->resizeTool->init($file);
		if(!$this->resizeTool->uploaded)
			return null;
		if($name != "")
			$this->resizeTool->file_new_name_body = $name;
		if($format->format != Image_Format::ORIGINAL)
			$this->resolveImageType($type);
		if($format->bg)
			$this->resizeTool->image_background_color = $format->bg;
		$this->resizeTool->file_overwrite = true;
		$this->resizeTool->jpeg_quality = 100;
		$this->imagePath = $folder;
		$this->resizeTool->image_greyscale = $format->grey;
		$this->resizeTool->blur = $format->blur;
		if($format->format == Image_Format::INSCRIBE)
			$this->inscribe($format);
		if($format->format == Image_Format::DESCRIBE)
			$this->describe($format);
		if($format->format == Image_Format::DESCRIBE_W)
			$this->describeW($format);
		if($format->format == Image_Format::DESCRIBE_H)
			$this->describeH($format);
		$res = true;
		if(!$format->stream)
			$res = $this->resizeTool->process($this->imagePath);
		else
			$res = $this->resizeTool->process();
		if($res !== false)
			return $this->getInfo();
		return null;
		
	}
	
	private function inscribe($format)
	{
		$this->resizeTool->image_resize = true;
		$this->resizeTool->image_x = $format->width;
		$this->resizeTool->image_y = $format->height;
		$this->resizeTool->image_ratio = true;
		if($format->bg)
			$this->resizeTool->image_ratio_fill = true;
		if(!$format->enlarge)
			$this->resizeTool->image_ratio_no_zoom_in = true;
	}
	
	private function describe($format)
	{
		
		$xScale = $this->resizeTool->image_src_x / $format->width;
		$yScale = $this->resizeTool->image_src_y / $format->height;
		if($xScale > $yScale)
			$this->describeH($format);
		else
			$this->describeW($format);
	}
	
	private function describeW($format)
	{
		$this->describeInternal($format, "w");
	}
	
	private function describeH($format)
	{
		$this->describeInternal($format, "h");
	}
	
	private function describeInternal($format, $side)
	{
		$this->resizeTool->image_resize = true;
		$this->resizeTool->image_x = $format->width;
		$this->resizeTool->image_y = $format->height;
		if(!$format->crop){
			if($side == "w")
				$this->resizeTool->image_ratio_y = true;
			else
				$this->resizeTool->image_ratio_x = true;
		}
		else
			$this->resizeTool->image_ratio_crop = true;
		if($format->bg)
			$this->resizeTool->image_ratio_fill = true;
		if(!$format->enlarge)
			$this->resizeTool->image_ratio_no_zoom_in = true;
	}
	
	private function resolveImageType($type)
	{
		$this->resizeTool->image_convert = $type;
	}
	
	public function clean()
	{
		if($this->resizeTool instanceof Utils_Image)
			$this->resizeTool->clean();
	}
	
	private function getInfo()
	{
		$info = getimagesize($this->resizeTool->file_dst_pathname);
		return array('path'=>$this->resizeTool->file_dst_pathname, 'width'=>$this->resizeTool->image_dst_x, 'height'=>$this->resizeTool->image_dst_y, 'mime'=>$info['mime'], 'size'=>filesize($this->resizeTool->file_dst_pathname));
	}
}
?>