<?php
    define('HOST','localhost');
    define('DB_NAME','knigidb');
    define('USER','knigi');
    define('PASSWORD','qdmnyt');
    define('DB_PREFIX', '');

$config = Config::getInstance();
$db = array();

$config = Config::getInstance();
$db = array();

$db['image'] = <<<TABLE
    CREATE TABLE `image` (
        `id` int(11) NOT NULL auto_increment,
        `width` int(5) default 0,
        `height` int(5) default 0,
        `size` int(11) default 0,
        `mime` char(15),
        `ord` int(5) default 0,
        PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['imageresize'] = <<<TABLE
    CREATE TABLE `imageresize` (
        `id` int(11) NOT NULL auto_increment,
        `name` char(50),
        `width` int(5) default 0,
        `height` int(5) default 0,
        `size` int(11) default 0,
        `mime` char(15),
        `image_id` int(11) NOT NULL,
		PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['users'] = <<<TABLE
	CREATE TABLE `users` (
		`id` int(11) NOT NULL auto_increment,
		`email` char(50) NOT NULL,
		`password` char(255) NOT NULL,
		`login` char(150) NOT NULL,
		`image_id` int(11),
		`name` char(150),
		`isblocked` tinyint(1) default 0,
		`roles` char(230),
		`gender` tinyint(1) default 0,
		`reader` tinyint(1) default 0,
		`phone` varchar(255),
		`birth_date` datetime,
		`library_id` int(11),
		`registration_date` datetime,
		`cbs_id` int(11),
		`ip` varchar(255),
		UNIQUE(`email`),
		UNIQUE(`login`),
		PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['articles'] = <<<TABLE
CREATE TABLE `articles` (
	`id` int(11) NOT NULL auto_increment,
	`parent_id` int(11) default 0,
	`url` char(100),
	`otherurl` char(100) NOT NULL,
	`name` text NOT NULL,
	`title` text NOT NULL,
	`metakeys` text NOT NULL,
	`descr` text NOT NULL,
	`text` longtext NOT NULL,
	`image_id` int(11),
	`ord` int(5) NOT NULL default 0,
	`def` tinyint(1) default 0,
	`flag1` tinyint(1) default 0,
	`flag2` tinyint(1) default 0,
	`published` tinyint(1) default 0,
	`code` char(200),
	`level` int(5) default 0,
	`childindex` int(7) default 0,
	`gallery_id` int(11),
	PRIMARY KEY  (`id`),
	UNIQUE(`url`),
	UNIQUE(`code`)
) Engine=MyISAM CHARSET=utf8
TABLE;

$db['common'] = <<<TABLE
CREATE TABLE `common` (
	`id` int(11) NOT NULL auto_increment,
	`settings` text,
	PRIMARY KEY  (`id`)
	) Engine=MyISAM CHARSET=utf8
TABLE;

$db['okrug'] = <<<TABLE
CREATE TABLE `okrug` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['library_types'] = <<<TABLE
CREATE TABLE `library_types` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['districts'] = <<<TABLE
CREATE TABLE `districts` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	`okrug_id` int(11),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['cbs_sb'] = <<<TABLE
CREATE TABLE `cbs_sb` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	`external_id` int(11),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['libraries'] = <<<TABLE
CREATE TABLE `libraries` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	`external_id` varchar(255),
	`cbs_sb_id` int(11),
	`type_id` int(11),
	`coords` varchar(255),
	`phone` varchar(255),
	`site` varchar(255),
	`address` varchar(255),
	`postindex` char(6),
	`schedule` text,
	`service` tinyint(1) default 0,
	`published` tinyint(1) default 0,
	`day_off` varchar(255),	
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['book_categories'] = <<<TABLE
CREATE TABLE `book_categories` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['book_types'] = <<<TABLE
CREATE TABLE `book_types` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['books'] = <<<TABLE
CREATE TABLE `books` (
	`id` int(11) NOT NULL auto_increment,
	`title` varchar(255),
	`library_id` int(11) NOT NULL,
	`external_id` int(11) NOT NULL,
	`category_id` int(11),
	`type_id` int(11),
	`age_category_id` int(11),
	`isbn` varchar(255),
	`year` mediumint,
	`status` tinyint default 0,
	`published` tinyint default 0,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['books_authors'] = <<<TABLE
CREATE TABLE `books_authors` (
	`book_id` int(11) NOT NULL,
	`author_id` int(11) NOT NULL,
	PRIMARY KEY  (`book_id`, `author_id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['age_categories'] = <<<TABLE
CREATE TABLE `age_categories` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	`adult` tinyint(1) default 0,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['authors'] = <<<TABLE
CREATE TABLE `authors` (
	`id` int(11) NOT NULL auto_increment,
	`name` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['imports'] = <<<TABLE
CREATE TABLE `imports` (
	`id` int(11) NOT NULL auto_increment,
	`date` datetime not null,
	`processed` tinyint(1) default 0,
	`file` varchar(255),
	`error` varchar(255),
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['orders'] = <<<TABLE
CREATE TABLE `orders` (
	`id` int(11) NOT NULL auto_increment,
	`user_id` int(11) NOT NULL,
	`status` tinyint default 0,
	`date` datetime NOT NULL,
	`books_count` tinyint NOT NULL,
	`libraries_count` tinyint NOT NULL,
	`confirmed_at` datetime,
	`reserved_untill` datetime,
	`extend_count` tinyint default 0,
	`expiration_notified` tinyint default 0,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['order_items'] = <<<TABLE
CREATE TABLE `order_items` (
	`id` int(11) NOT NULL auto_increment,
	`order_id` int(11) NOT NULL,
	`user_id` int(11) NOT NULL,
	`book_id` int(11) NOT NULL,
	`library_id` int(11) NOT NULL,
	`status` tinyint default 0,
	`date` datetime NOT NULL,
	`left_time_start` datetime,
	`processed_at` datetime,
	`comment` text,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['reviews'] = <<<TABLE
CREATE TABLE `reviews` (
	`id` int(11) NOT NULL auto_increment,
	`order_number` int(11) NOT NULL,
	`user_id` int(11) NOT NULL,
	`library_id` int(11) NOT NULL,
	`value` tinyint default 0,
	`review` text,
	`date` datetime,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['cart'] = <<<TABLE
CREATE TABLE `cart` (
	`id` int(11) NOT NULL auto_increment,
	`book_id` int(11) NOT NULL,
	`library_id` int(11),
	`uid` varchar(100) NOT NULL,
	`date` datetime NOT NULL,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$db['mail_queue'] = <<<TABLE
CREATE TABLE `mail_queue` (
	`id` int(11) NOT NULL auto_increment,
	`type` varchar(100) NOT NULL,
	`date` datetime NOT NULL,
	`data` longtext NOT NULL,
	`email` varchar(100) NOT NULL,
	`processed` tinyint default 0,
	`started_at` datetime,
	PRIMARY KEY  (`id`)
    ) Engine=MyISAM CHARSET=utf8
TABLE;

$initQueries = array(
    "INSERT INTO `users` (`login`, `password`, `email`, `roles`, `name`) VALUES('$config->superUserLogin', '".md5("admin")."', 'admin@mail.ru', '1,2,3', '')",
    "INSERT INTO `common` (settings) VALUES ('')"
);

$config->initQueries = $initQueries;
$config->db = $db;
?>
