<?php
class ArticlesController extends SiteController
{
	private $articleDao;
	
	public function __construct(){
		parent::__construct();
		$this->articleDao = new Article_Dao();
	}
	
	public function index(){
		
		
	}
	
	public function get(){
		$this->getArticle('/' . $this->route['url'], true);
	}
	
	private function getArticle($url, $required = false){
		$article = $this->articleDao->getByUrl($url);
		if($article == null && $required)
			throw new PageNotFoundException();
		$this->article = $article;
		$this->title = $article->title;
		$this->keywords = $article->metakeys;
		$this->description = $article->descr;
		$this->articles = $this->articleDao->all(Db_Criteria::create(array('published' => 1)));
	}
	
}
?>