<?php
class BooksController extends SiteController
{
	public function __construct(){
		parent::__construct();
	}

	public function index(){
        $bytitle = null;
        if(isset($this->route['bytitle'])){
            $bytitle = $this->route['bytitle'];
        }
        $byauthor = null;
        if(isset($this->route['byauthor'])){
            $byauthor = $this->route['byauthor'];
        }
//        $category = null;
//        if(isset($this->route['category'])){
//			$category = $this->categoryDao->get(intval($this->route['category']));
//			if($category == null){
//				throw new PageNotFoundException();
//			}
//		}
		$categories = null;
        if(isset($this->route['category'])){
            $categoriesArr = array_map('intval', explode(',', $this->route['category']));
            $categories = $this->categoryDao->get($categoriesArr);
			if($categories == null){
				throw new PageNotFoundException();
			}
		}
		$age = null;
		if(isset($this->route['age'])){
			$age = $this->ageDao->get(intval($this->route['age']));
			if($age == null){
				throw new PageNotFoundException();
			}
		}
        $type = null;
        if(isset($this->route['type'])){
            $type = $this->typeDao->get(intval($this->route['type']));
            if($type == null){
                throw new PageNotFoundException();
            }
        }
        $region = null;
        if(isset($this->route['region'])){
            $region = $this->route['region'];
            if($region == null){
                throw new PageNotFoundException();
            }
        }
        $district = null;
        if(isset($this->route['district'])){
            $district = $this->route['district'];
            if($district == null){
                throw new PageNotFoundException();
            }
        }
        $metro = null;
        if(isset($this->route['metro'])){
            $metro = $this->route['metro'];
            if($metro == null){
                throw new PageNotFoundException();
            }
        }
        $lang = null;
        if(isset($this->route['lang'])){
            $lang = $this->route['lang'];
            if($lang == null){
                throw new PageNotFoundException();
            }
        }
		$library = null;
		if(isset($this->route['library'])){
			$library = $this->libraryDao->get(intval($this->route['library']));
			if($library == null){
				throw new PageNotFoundException();
			}
		}
        $fund = null;
        if(isset($this->route['fund'])){
            $fund = $this->route['fund'];
            if($fund == null){
                throw new PageNotFoundException();
            }
        }
		$title = isset($_GET['title']) ? $_GET['title'] : null;
		$baseUrl = "/books";
		if($bytitle){
            $baseUrl .= "/bytitle/" . $bytitle;
        }
        if($byauthor){
            $baseUrl .= "/byauthor/" . $byauthor;
        }
//		if($category){
//			$baseUrl .= "/category/" . $category->id;
//		}
        if($categories){
            $baseUrl .= "/category/" . implode(',', $categoriesArr);
        }
		if($age){
			$baseUrl .= "/age/" . $age->id;
		}
        if($type){
            $baseUrl .= "/type/" . $type->id;
        }
        if($region){
            $baseUrl .= "/region/" . $region;
        }
        if($district){
            $baseUrl .= "/district/" . $district;
        }
        if($metro){
            $baseUrl .= "/metro/" . $metro;
        }
        if($lang){
            $baseUrl .= "/lang/" . $lang;
        }
		if($library){
			$baseUrl .= "/library/" . $library->id;
		}
        if($fund){
            $baseUrl .= "/fund/" . $fund;
        }

		$this->getBooks($baseUrl, $this->parsePage("page"), $library, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, $fund);

		$allLibraries = $this->cache->get("allLibraries");
        if ($allLibraries) {
            $this->allLibraries = $allLibraries;
        } else {
            $this->allLibraries = $this->libraryDao->all(Db_Criteria::create(array('service' => 1, 'published' => 1))->add(Db_Exp::eq('has_books', true))->field(array('id', 'name', 'address'))->order('name asc'));
            $this->cache->set("allLibraries", $this->allLibraries, 3600);
        }
	}

	public function get(){
		$library = $this->libraryDao->get(intval($this->route['library']));
		if($library == null || $library->service == 0 || $library->published == 0){
			throw new PageNotFoundException();
		}
		$book = $this->bookDao->get(intval($this->route['id']));
		if($book == null){
			throw new PageNotFoundException();
		} else if($book->library_id != $library->id){
            throw new PageNotFoundException();
        }

        if ($this->currentUser && !$this->currentUser->isInRole(Roles::LRENTITY)) {
		    if($book->fund_type == Book_Fund::EXCHANGE){
                throw new PageNotFoundException();
            }
        } elseif (!$this->currentUser) {
            if($book->fund_type == Book_Fund::EXCHANGE){
                throw new PageNotFoundException();
            }
        }

		$this->header = "book";
		$this->book = $book;

		$this->bookAuthors = $this->authorDao->all(Db_Criteria::create()->sql("select * from authors where id in (select author_id from books_authors where book_id = {$book->id})"));
		$this->library = $library;

		$this->ignoreLibraryFilter = true;
		$this->getBooks("/library/{$library->id}/books", 0, $library, null, null, null, null, null, null, null, null, null, null, null, true);
        $this->allLibraries = [];
	}

	public function author(){
		$this->output = false;
		$this->jsonHeaders();
		$name = trim($_GET['term']);
		$result = array();
		if(mb_strlen($name) >= 3){
			$name = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $name);
			$authors = $this->authorDao->all(Db_Criteria::create()->add(Db_Exp::like('name', $name))->perPage(10));
			foreach($authors as $a){
				$result[] = array('label' => $a->name, 'value' => $a->id);
			}
		}
		echo json_encode($result);
	}
}
?>