<?php
class CartController extends SiteController{
	
	public function __construct()
    {
		parent::__construct();

        $this->ages = Ages::getAges();
	}
	
	public function index(){
		$this->noCache();
		$this->layout = 'cart';
		$ids = $this->cart->get();
		$books = null;
		$timeLeft = null;
		if($ids){
			$books = $this->bookDao->get($ids);
            $timeLeft = $this->cart->timeLeft();
		}
		if($books){
			$libraryIds = array();
			foreach($books as $b){
				$libraryIds[] = $b->library_id;
			}
			$this->getAuthors($ids);
			$this->getLibraries($libraryIds);
		}else{
			$books = array();
		}
		$this->books = $books;
        $this->timeLeft = $timeLeft;
	}
	
	public function add(){
		$this->output = false;
		$this->jsonHeaders(true);

		$book = $this->bookDao->get(intval($_POST['id']));
                if($book == null || $book->published == 0){
                    echo json_encode(array('status' => 'notavailable'));
                    return;
                }
		if($book == null || !$book->available){
                    echo json_encode(array('status' => 'wasadded'));
                    return;
		}
//		$limit = Presets_Dao::fetch('daily_limit', 10);
		$aLimit = 10; // All Other books limit per day
		$eLimit = 100; // Exchange books limit per day

//		$n = count($this->cart->get());
		$aN = $this->cart->countAllOther();
                $eN = $this->cart->countExchange();

		$currentUser = Auth_Auth::getUser();
		if($currentUser){
			$orderDao = new Order_Dao();

                        $aN += $orderDao->getBooksCount($currentUser->id);
                        $eN += $orderDao->getExBooksCount($currentUser->id);
//			$n += $orderDao->getDayOrderCount($currentUser->id);
		} else {
                        echo json_encode(array('status' => 'notloggedin'));
                        return;
                }

		if($aN >= $aLimit && ($book->fund_type == 1)){
		    $this->serializeCart(true, $aLimit, null, $currentUser->id);
		    return;
                }
                if($eN >= $eLimit && ($book->fund_type == 2)){
		    $this->serializeCart(true, $eLimit);
		    return;
                }
//		if($n >= $limit){
//			$this->serializeCart(true, $limit);
//			return;
//		}

		$result = $this->cart->add($book->id, $book->library_id, $book->fund_type, $currentUser);

		if($result){
			$this->bookDao->update($book->id, array('status' => Book_Status::CART));
		}
		$this->serializeCart(false, 0, $book->fund_type);
	}
	
	public function delete(){
		$this->output = false;
		$this->jsonHeaders(true);
		$bookId = intval($_POST['id']);
		$this->cart->remove($bookId);
		$book = $this->bookDao->get($bookId);
		if($book != null && $book->status == Book_Status::CART){
			$this->bookDao->update($book->id, array('status' => Book_Status::ACTIVE));
		}
		$this->serializeCart();
	}
	
	public function clear(){
		$this->output = false;
		$this->jsonHeaders(true);
		$this->cart->clear();
		$this->serializeCart();
	}
	
	private function serializeCart($error = false, $limit = 0, $fund_type = null, $desc = ""){
		if($error){
			echo json_encode(array('total' => count($this->cart->get()), 'status' => 'limit', 'limit' => $limit, 'desc' => $desc));
		}else{
			echo json_encode(array('total' => count($this->cart->get()), 'fund_type' => $fund_type));
		}
	}	
}
?>
