<?php
class IndexController extends SiteController
{
	public function __construct(){
		parent::__construct();
	}
	
	public function index(){
		$this->getBooks("/books", 0, null, null, null, null, null, null, null, null, null, null, null, null, false);
        $allLibraries = $this->cache->get("allLibraries");
        if ($allLibraries) {
            $this->allLibraries = $allLibraries;
        } else {
            $this->allLibraries = $this->libraryDao->all(Db_Criteria::create(array('service' => 1, 'published' => 1))->add(Db_Exp::eq('has_books', true))->field(array('id', 'name', 'address'))->order('name asc'));
            $this->cache->set("allLibraries", $this->allLibraries, 300);
        }
        if($this->route['parsedUrl'][0] == 'review'){
			$this->showReview = intval($this->route['id']);
			if ($this->mobile) {
			    $this->review();
                $this->template = 'review';
                $this->layout = 'site';
            }
		}
	}
	
	public function review(){
		$user = Auth_Auth::getUser();
		if($user == null){
			throw new PageNotFoundException();
		}
		$this->noCache();
		$reviewDao = new Review_Dao();
		$review = $reviewDao->get(intval($this->route['id']));
		if($review == null || $review->user_id != $user->id){
			throw new PageNotFoundException();
		}
		$this->layout = 'review';
		$this->review = $review;
		$this->library = $this->libraryDao->get($review->library_id);
		
	}

	public function complete(){
	    $this->template = 'reviewcomplete';
    }
	
	public function sendReview(){
		$this->output = false;
		$this->jsonHeaders(true);
		$user = Auth_Auth::getUser();
        if($user == null){
			throw new PageNotFoundException();
		}

		$reviewDao = new Review_Dao();
		$review = $reviewDao->get(intval($_POST['id']));
		if($review == null || $review->user_id != $user->id){
			throw new PageNotFoundException();
		}
		$comment = strip_tags($_POST['comment']);
		$reviewDao->update($review->id, array('value' => intval($_POST['rating']), 'review' => mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $comment), 'date' => date('Y-m-d H:i:s')));
		echo json_encode(array('status' => 'ok', 'valid' => true));
	}
}
?>