<?php
class LibrarianController extends SiteController
{	
	private $user;
	
	private $l;
	
	private $itemDao;
	
	private $orderDao;

	private $cartDao;

    private $connection;
	
	public function __construct(){
		parent::__construct();
		$this->itemDao = new Order_Item_Dao();
		$this->orderDao = new Order_Dao();
		$this->cartDao = new Cart_Dao();

        $this->connection = new Db_Mysql_Adapter();
	}
	
	public function before(){
		parent::before();
		$this->user = Auth_Auth::getUser();
		if($this->user == null || !$this->user->isInRole(Roles::LIBRARY)){
			throw new PageNotFoundException();
		}
		$this->header = 'librarian';
		$this->l = $this->libraryDao->get($this->user->library_id);

        $this->allBooks = $this->bookDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id]));
        $this->listBooks = $this->bookDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 0', 'fund_type = 1']));
        $this->pendingBooks = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 0']));
        $this->reservedBooks = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 1']));
        $this->expiredBooks = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 5']));
        $this->absentBooks = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 2']));
        $this->takenBooks = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 3']));
        $this->cartBooks = $this->cartDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id]));
        $this->refusedToday = $this->itemDao->count(Db_Criteria::create(['library_id = ' . $this->user->library_id, 'status = 4'])->add(Db_Exp::ge('processed_at', date('Y-m-d 00:00:00'))));
    }

    /**
     * THIS METHOD OVERRIDES PARENT METHOD!!!
     */
    protected function getBooks($baseUrl, $page, $library, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, $fund, $ignoreLibraryFilter = false){
        $perPage = 20;
        $sql = null;
        $filters = array();

        if($byauthor != null){
            $sql = "select books.*, (select min(authors.name) from books_authors join authors on authors.id = books_authors.author_id where books_authors.book_id = books.id) as author from books";

            $criteria = Db_Criteria::create()->before($sql);
            $criteria->add(array('status' => Book_Status::ACTIVE, 'published' => 1, 'fund_type' => Book_Fund::ALLOTHER))->order(Db_Exp::orderBy('author', $byauthor));

            $filters['byauthor'] = $byauthor;
        } else {
            $criteria = Db_Criteria::create(array('status' => Book_Status::ACTIVE, 'published' => 1, 'fund_type' => Book_Fund::ALLOTHER));
        }
        if($library != null){
            $criteria->add(Db_Exp::eq('library_id', $library->id));
            if(!$ignoreLibraryFilter){
                $filters['library'] = $library->id;
            }
        }else{
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where service = 1 and published = 1)"));
        }
//        if($category != null){
//            $criteria->add(Db_Exp::eq('category_id', $category->id));
//            $filters['category'] = $category->id;
//        }
        if(!empty($categories)){
            $categoriesIds = [];
            foreach ($categories as $category) {
                $categoriesIds[] = (int)$category->id;
            }
            $criteria->add(Db_Exp::in('category_id', $categoriesIds));
            $filters['category'] = implode(',', $categoriesIds);
        }
        if($age != null){
            $criteria->add(Db_Exp::eq('age_category_id', $age->id));
            $filters['age'] = $age->id;
        }
        if($type != null){
            $criteria->add(Db_Exp::eq('type_id', $type->id));
            $filters['type'] = $type->id;
        }
        if($region != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where region = '" . $region . "')"));
            $filters['region'] = $region;
        }
        if($district != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where district = '" . $district . "')"));
            $filters['district'] = $district;
        }
        if($metro != null){
            $criteria->add(Db_Exp::sql("library_id in (select id from libraries where metro = '" . $metro . "')"));
            $filters['metro'] = $metro;
        }
//        if($lang != null){
//            $criteria->add(Db_Exp::eq('lang', $lang));
//            $filters['lang'] = $lang;
//        }
        if($lang != null){
            if($lang == 'ru') {
                $criteria->add(Db_Exp::eq('lang', 'ru'));
            } else {
                $criteria->add(Db_Exp::ne('lang', 'ru'));
            }
            $filters['lang'] = $lang;
        }
        if($bytitle != null){
            $criteria->order(Db_Exp::orderBy('title', $bytitle));
            $filters['bytitle'] = $bytitle;
        }

        $author = isset($_GET['author']) ? $_GET['author'] : null;
        if($author){
            $filters['author'] = htmlentities($author);
            $authors = $this->getRequestAuthors($author);
            if($authors){
                $aids = join(',', $authors);
                $criteria->add(Db_Exp::sql("id in (select book_id from books_authors where author_id in ($aids))"));
            }else{
                $criteria->add(Db_Exp::sql("id = 0"));
            }
        }
        if($title){
            $criteria->add(Db_Exp::like('title', mysqli_real_escape_string($GLOBALS["___mysqli_ston"], $title)));
            $filters['title'] = htmlentities($title, null, 'UTF-8');
        }
        if ($byauthor != null) {
            $books = $this->bookDao->all($criteria->page($page)->perPage($perPage));
        } else
            $books = $this->bookDao->all($criteria->page($page)->perPage($perPage)->order('title asc'));
        $count = $this->bookDao->count($criteria);

        $this->page = $page + 1;
        $this->pages = ceil($count / $perPage);
        $this->count = $count;
        $this->books = $books;
        $this->baseUrl = $baseUrl;
        $this->filters = $filters;

        $ids = array();
        $libraryIds = array();
        foreach($books as $b){
            $ids[] = $b->id;
            $libraryIds[] = $b->library_id;
        }
        $this->getAuthors($ids);
        $this->getCategories();
        $this->getAges();
        $this->getTypes();
        $this->getRegions();
        $this->getDistricts();
        $this->getMetros();
        $this->getLangs();
        $this->getLibraries($libraryIds);
    }

	public function index(){
        $bytitle = null;
        if(isset($this->route['bytitle'])){
            $bytitle = $this->route['bytitle'];
        }
        $byauthor = null;
        if(isset($this->route['byauthor'])){
            $byauthor = $this->route['byauthor'];
        }
//	    $category = null;
//		if(isset($this->route['category'])){
//			$category = $this->categoryDao->get(intval($this->route['category']));
//			if($category == null){
//				throw new PageNotFoundException();
//			}
//		}
        $categories = null;
        if(isset($this->route['category'])){
            $categoriesArr = array_map('intval', explode(',', $this->route['category']));
            $categories = $this->categoryDao->get($categoriesArr);
            if($categories == null){
                throw new PageNotFoundException();
            }
        }
		$age = null;
		if(isset($this->route['age'])){
			$age = $this->ageDao->get(intval($this->route['age']));
			if($age == null){
				throw new PageNotFoundException();
			}
		}
        $type = null;
        if(isset($this->route['type'])){
            $type = $this->typeDao->get(intval($this->route['type']));
            if($type == null){
                throw new PageNotFoundException();
            }
        }
        $region = null;
        if(isset($this->route['region'])){
            $region = $this->route['region'];
            if($region == null){
                throw new PageNotFoundException();
            }
        }
        $district = null;
        if(isset($this->route['district'])){
            $district = $this->route['district'];
            if($district == null){
                throw new PageNotFoundException();
            }
        }
        $metro = null;
        if(isset($this->route['metro'])){
            $metro = $this->route['metro'];
            if($metro == null){
                throw new PageNotFoundException();
            }
        }
        $lang = null;
        if(isset($this->route['lang'])){
            $lang = $this->route['lang'];
            if($lang == null){
                throw new PageNotFoundException();
            }
        }
		$title = isset($_GET['title']) ? $_GET['title'] : null;
		$baseUrl = "/librarian";
        if($bytitle){
            $baseUrl .= "/bytitle/" .$bytitle;
        }
        if($byauthor){
            $baseUrl .= "/byauthor/" . $byauthor;
        }
//		if($category){
//			$baseUrl .= "/category/" . $category->id;
//		}
        if($categories){
            $baseUrl .= "/category/" . implode(',', $categoriesArr);
        }
		if($age){
			$baseUrl .= "/age/" . $age->id;
		}
        if($type){
            $baseUrl .= "/type/" . $type->id;
        }
        if($region){
            $baseUrl .= "/region/" . $region;
        }
        if($district){
            $baseUrl .= "/district/" . $district;
        }
        if($metro){
            $baseUrl .= "/metro/" . $metro;
        }
        if($lang){
            $baseUrl .= "/lang/" . $lang;
        }
        /**
         * Calling self getBooks method, not parent
         */
		$this->getBooks($baseUrl, $this->parsePage("page"), $this->l, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, null, true);
		$this->allLibraries = $this->libraryDao->all(Db_Criteria::create(array('service' => 1, 'published' => 1))->field(array('id', 'name', 'address'))->order('name asc'));
	}

	public function allBooks(){
        $this->partial = 'all';

        $page = $this->parsePage("page");

        $perPage = 50;
        $criteria = Db_Criteria::create(array('library_id' => $this->l->id));
        $this->count = $this->bookDao->count($criteria);

        $baseUrl = "/librarian/allbooks";

        $books = $this->bookDao->all($criteria->page($page)->perPage($perPage)->order('title asc'));
        $count = $this->bookDao->count($criteria);

        $this->page = $page + 1;
        $this->pages = ceil($count / $perPage);
        $this->count = $count;
        $this->books = $books;
        $this->baseUrl = $baseUrl;

        foreach($books as $book){
            $bookIds[] = $book->id;
        }
        $this->getCategories();
        $this->getAges();
        $this->getTypes();
        $this->getAuthors($bookIds);
        $this->parsePage("page");
        $this->checkOpenOrder();
    }

    public function absentBooks(){
        $this->partial = 'books';
        $criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => Order_Status::ABSENT));
        $this->count = $this->itemDao->count($criteria);
        $items = $this->itemDao->all($criteria->order('id asc')->perPage(100));
        $bookIds = array();
        foreach($items as $item){
            $bookIds[] = $item->book_id;
        }
        $this->getCategories();
        $this->getAges();
        $this->getAuthors($bookIds);
        $this->items = $items;
        $this->checkOpenOrder();
    }

    public function refusedBooks(){
        $this->partial = 'books';
        $criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => Order_Status::REFUSED))->add(Db_Exp::ge('processed_at', date('Y-m-d 00:00:00')));
        $this->count = $this->itemDao->count($criteria);
        $items = $this->itemDao->all($criteria->order('id asc')->perPage(100));
        $bookIds = array();
        foreach($items as $item){
            $bookIds[] = $item->book_id;
        }
        $this->getCategories();
        $this->getAges();
        $this->getAuthors($bookIds);
        $this->items = $items;
        $this->checkOpenOrder();
    }

	public function confirm(){
		$this->output = false;
		$item = $this->itemDao->get(intval($_POST['id']));
		if($item == null || $item->library_id != $this->l->id){
			throw new PageNotFoundException();
		}
		if($item->status != Order_Status::NEW_ORDER){
			throw new PageNotFoundException();
		}
		$this->itemDao->update($item->id, array('status' => Order_Status::READY, 'processed_at' => date("Y-m-d H:i:s")));
        $order = $this->orderDao->get($item->order_id);

        /**
         * Logging Order Item status if book was FREE and become READY
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::FREE)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::NEW_ORDER, 'status_2' => Order_Status::READY, 'created_at' => date("Y-m-d H:i:s"))));
        $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::NEW_ORDER, 'status_2' => Order_Status::READY, 'created_at' => date("Y-m-d H:i:s")));

        $this->handleOrder($order, $item);
	}
	
	public function absent($data){
		$item = $this->itemDao->get(intval($data['id']));
		if($item == null || $item->library_id != $this->l->id){
			throw new PageNotFoundException();
		}
		if($item->status != Order_Status::NEW_ORDER){
			throw new PageNotFoundException();
		}
		$comment = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], htmlentities($data['comment'], null, 'UTF-8'));
		$name = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], htmlentities($data['name'], null, 'UTF-8'));
		$position = mysqli_real_escape_string($GLOBALS["___mysqli_ston"], htmlentities($data['position'], null, 'UTF-8'));
		$comment = $name . '. ' . $position . '. ' . $comment;

        /**
         * Logging Order Item status if book was READY but it was ABSENT
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_2' => Order_Status::NEW_ORDER)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::NEW_ORDER, 'status_2' => Order_Status::ABSENT, 'created_at' => date("Y-m-d H:i:s"))));
        $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::NEW_ORDER, 'status_2' => Order_Status::ABSENT, 'created_at' => date("Y-m-d H:i:s")));

        $this->itemDao->update($item->id, array('status' => Order_Status::ABSENT, 'processed_at' => date("Y-m-d H:i:s"), 'comment' => $comment));
		$order = $this->orderDao->get($item->order_id);
		$this->handleOrder($order, $item);
	}
	
	public function taken(){
		$this->output = false;
		$item = $this->itemDao->get(intval($_POST['id']));
		if($item == null || $item->library_id != $this->l->id){
			throw new PageNotFoundException();
		}
		if($item->status != Order_Status::READY){
			throw new PageNotFoundException();
		}

        /**
         * Logging Order Item status if book was READY and become TAKEN
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_2' => Order_Status::READY)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::READY, 'status_2' => Order_Status::TAKEN, 'created_at' => date("Y-m-d H:i:s"))));
        $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::READY, 'status_2' => Order_Status::TAKEN, 'created_at' => date("Y-m-d H:i:s")));

        $this->itemDao->update($item->id, array('status' => Order_Status::TAKEN, 'taken_at' => date("Y-m-d H:i:s")));
        $this->bookDao->update($item->book_id, array('status' => Book_Status::TAKEN));
		
		$order = $this->orderDao->get($item->order_id);
		$this->finishOrder($order, $item);
	}

    public function exTaken(){
        $this->output = false;
        $orderId = intval($_POST['id']);

        $items = $this->itemDao->all(Db_Criteria::create(array('library_id' => $this->user->library_id, 'order_id' => $orderId, 'status' => Order_Status::READY)));

        /**
         * Logging Order Item status if book was READY and become TAKEN
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_2' => Order_Status::READY)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::READY, 'status_2' => Order_Status::TAKEN, 'created_at' => date("Y-m-d H:i:s"))));

        foreach ($items as $item) {
            $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::READY, 'status_2' => Order_Status::TAKEN, 'created_at' => date("Y-m-d H:i:s")));

            $this->itemDao->update($item->id, array('status' => Order_Status::TAKEN, 'taken_at' => date("Y-m-d H:i:s")));
            $this->bookDao->update($item->book_id, array('status' => Book_Status::TAKEN));

            $order = $this->orderDao->get($item->order_id);
            $this->finishOrder($order, $item);
        }
    }
	
	public function refuse(){
		$this->output = false;
		$item = $this->itemDao->get(intval($_POST['id']));
		if($item == null || $item->library_id != $this->l->id){
			throw new PageNotFoundException();
		}
		if($item->status != Order_Status::READY){
			throw new PageNotFoundException();
		}

        /**
         * Logging Order Item status if book was READY but user REFUSED it
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_2' => Order_Status::READY)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::READY, 'status_2' => Order_Status::REFUSED, 'created_at' => date("Y-m-d H:i:s"))));
        $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::READY, 'status_2' => Order_Status::REFUSED, 'created_at' => date("Y-m-d H:i:s")));

        $this->itemDao->update($item->id, array('status' => Order_Status::REFUSED));
		$this->bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));
		
		$order = $this->orderDao->get($item->order_id);
		$this->finishOrder($order, $item);
	}

	public function exRefuse(){
        $this->output = false;
        $orderId = intval($_POST['id']);

        $items = $this->itemDao->all(Db_Criteria::create(array('library_id' => $this->user->library_id, 'order_id' => $orderId, 'status' => Order_Status::READY)));

        /**
         * Logging Order Item status if book was READY but user REFUSED it
         */
//        $logItem = $this->orderLogDao->one(Db_Criteria::create(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_2' => Order_Status::READY)));
//        $this->orderLogDao->update($logItem->id, (array('status_1' => Order_Status::READY, 'status_2' => Order_Status::REFUSED, 'created_at' => date("Y-m-d H:i:s"))));

        foreach ($items as $item) {
            $this->orderLogDao->insert(array('order_id' => $item->order_id, 'book_id' => $item->book_id, 'status_1' => Order_Status::READY, 'status_2' => Order_Status::REFUSED, 'created_at' => date("Y-m-d H:i:s")));

            $this->itemDao->update($item->id, array('status' => Order_Status::REFUSED));
            $this->bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));

            $order = $this->orderDao->get($item->order_id);
            $this->finishOrder($order, $item);
        }
	}
	
	public function order(){
		$this->noCache();
		$this->layout = 'librarian-order';
		$order = $this->orderDao->get(intval($this->route['id']));
                $this->order_status = null;
		if($order == null || $order->status == Order_Status::NEW_ORDER || $order->status == Order_Status::EXPIRED){
                        $this->order_status = $order->status;
			return;
		}
		$this->items = $this->itemDao->all(Db_Criteria::create(array('order_id' => $order->id, 'library_id' => $this->l->id)));

        /**
         * Checking book fund type
         */
		$this->fund = $this->itemDao->one(Db_Criteria::create(array('order_id' => $order->id, 'library_id' => $this->l->id)))->book->fund_type;

		if(!$this->items){
			return;
		}
		$this->order = $order;
		$bookIds = array();
		foreach($this->items as $item){
			$bookIds[] = $item->book_id;
		}
		$this->getAuthors($bookIds);
	}
	
	public function showAbsent(){
		$item = $this->itemDao->get(intval($this->route['id']));
		if($item == null || $item->library_id != $this->l->id){
			throw new PageNotFoundException();
		}
		if($item->status != Order_Status::NEW_ORDER){
			throw new PageNotFoundException();
		}
		$this->item = $item;
		$this->layout = 'absent';
	}

	public function pending(){
		$this->partial = 'books';
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => Order_Status::NEW_ORDER));
		$this->count = $this->itemDao->count($criteria);
		$items = $this->itemDao->all($criteria->order('id asc')->perPage(100));
		$bookIds = array();
		foreach($items as $item){
			$bookIds[] = $item->book_id;
		}
		$this->getCategories();
		$this->getAges();
		$this->getTypes();
		$this->getAuthors($bookIds);
		$this->items = $items;
		$this->checkOpenOrder();
	}

    public function showOrders(){
        $user = Auth_Auth::getUser();
        if($user == null){
            throw new PageNotFoundException();
        }
        $this->partial = 'orders';
        $this->noCache();
        $result = array(Order_Status::NEW_ORDER => array(), Order_Status::READY => array(), Order_Status::TAKEN => array());
        $orders = $this->orderDao->all(Db_Criteria::create(array('user_id' => $user->id))->order('id desc'));
        $bids = array();
        foreach($orders as $order){
            $status = $order->status;
            if($order->status == Order_Status::TAKEN || $order->status == Order_Status::REFUSED || $order->status == Order_Status::EXPIRED || $order->status == Order_Status::ABSENT){
                $status = Order_Status::TAKEN;
            }
            $result[$status][] = $order;
        }
        $this->orders = $orders;
        $this->groupped = $result;
    }
	
	public function cart(){
		$this->partial = 'cart';
		$cartDao = new Cart_Dao();
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id));
		$this->count = $cartDao->count($criteria);
		$items = $cartDao->all($criteria->order('id asc')->perPage(100));
		$bookIds = array();
		foreach($items as $item){
			$bookIds[] = $item->book_id;
		}
		$this->getCategories();
		$this->getAges();
        $this->getTypes();
        $this->getAuthors($bookIds);
		$this->items = $items;
	}
	
	public function exportBooks(){
		header("Content-Type: text/html");
		header('Content-Disposition: attachment;filename="books-export.xls"');
		header('Cache-Control: max-age=0');
		$this->layout = 'books-export';
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => Book_Status::ACTIVE))->order('title asc')->perPage(100);
		$this->view->criteria = $criteria;
		$this->view->bookDao = $this->bookDao;
		$this->view->authorDao = $this->authorDao;
	}
	
	public function export(){
		header("Content-Type: text/html");
		header('Content-Disposition: attachment;filename="export.xls"');
		header('Cache-Control: max-age=0');
		$this->output = false;
		$view = View_View::getInstance();
		
		$type = $this->route['parsedUrl'][2];
		$statuses = array(Order_Status::NEW_ORDER);
		if($type == 'finished'){
			$statuses = array(Order_Status::READY);
		}
		if($type == 'taken-books'){
			$statuses = array(Order_Status::TAKEN);
		}
        if($type == 'absent-books'){
            $statuses = array(Order_Status::ABSENT);
        }
        if($type == 'refused-books'){
            $statuses = array(Order_Status::REFUSED);
        }
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id))->add(Db_Exp::in('status', $statuses));
		if($type == 'taken-books'){
			$criteria->order('id desc');
		}else{
			$criteria->order('id asc');
		}
		$criteria->perPage(100);
		
		$this->getCategories($view);
		$this->getAges($view);
		$view->type = $type;
		
		echo $view->renderFile('layouts/export/orders/header');
		$page = 0;
		do{
			$criteria->page($page);
			$page++;
			$items = $this->itemDao->all($criteria);
			$bookIds = array();
			foreach($items as $item){
				$bookIds[] = $item->book_id;
			}
			$this->getAuthors($bookIds, $view);
			$view->items = $items;
			echo $view->renderFile('layouts/export/orders/items');
		}while($items);
		echo $view->renderFile('layouts/export/orders/footer');
	}
	
	
	public function exportCart(){
		header("Content-Type: text/html");
		header('Content-Disposition: attachment;filename="export-cart.xls"');
		header('Cache-Control: max-age=0');
		$this->output = false;
		$view = View_View::getInstance();
		
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id));
		$criteria->order('id asc');
		$criteria->perPage(100);
		
		$this->getCategories($view);
		$this->getAges($view);
		
		$cartDao = new Cart_Dao();
		
		echo $view->renderFile('layouts/export/cart/header');
		$page = 0;
		do{
			$criteria->page($page);
			$page++;
			$items = $cartDao->all($criteria);
			$bookIds = array();
			foreach($items as $item){
				$bookIds[] = $item->book_id;
			}
			$this->getAuthors($bookIds, $view);
			$view->items = $items;
			echo $view->renderFile('layouts/export/cart/items');
		}while($items);
		echo $view->renderFile('layouts/export/cart/footer');
	}

    public function exportOrder(){
        header("Content-Type: text/html");
        header('Content-Disposition: attachment;filename="export_order.xls"');
        header('Cache-Control: max-age=0');
        $this->output = false;
        $view = View_View::getInstance();

        $orderId = $this->route['order_id'];

        $status = Order_Status::READY;
        $criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => $status, 'order_id' => $orderId));
        $criteria->perPage(100);

        echo $view->renderFile('layouts/export/order/header');
        $page = 0;
        do{
            $criteria->page($page);
            $page++;
            $items = $this->itemDao->all($criteria);
            $bookIds = array();
            foreach($items as $item){
                $bookIds[] = $item->book_id;
            }
            $this->getAuthors($bookIds, $view);
            $this->getCategories();
            $this->getAges();
            $view->items = $items;
            echo $view->renderFile('layouts/export/order/items');
        }while($items);
        echo $view->renderFile('layouts/export/order/footer');
    }

    public function exportAll(){
        header("Content-Type: text/html");
        header('Content-Disposition: attachment;filename="all_books.xls"');
        header('Cache-Control: max-age=0');
        $this->output = false;
        $view = View_View::getInstance();

        $criteria = Db_Criteria::create(array('library_id' => $this->l->id));
        $criteria->perPage(100);

        echo $view->renderFile('layouts/export/all/header');
        $page = 0;
        do{
            $criteria->page($page);
            $page++;
            $books = $this->bookDao->all($criteria);
            $bookIds = array();
            foreach($books as $book){
                $bookIds[] = $book->id;
            }
            $this->getAuthors($bookIds, $view);
            $view->books = $books;
            echo $view->renderFile('layouts/export/all/items');
        }while($books);
        echo $view->renderFile('layouts/export/all/footer');
    }

    public function finished(){
		$this->partial = 'books';
        $perPage = 20;
		$status = Order_Status::READY;
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => $status));
		$count = $this->itemDao->count($criteria);
        $page = $this->parsePage("page");
//        $items = $this->itemDao->all($criteria->order('id asc')->page($page)->perPage($perPage));
        $query = "select * from order_items i join orders o on i.order_id = o.id join books b on b.id = i.book_id where i.library_id = ".$this->l->id." and i.status = ".$status." order by o.reserved_untill asc limit ".$perPage." offset ".($page*$perPage);
        $items = $this->itemDao->all(Db_Criteria::create()->sql($query));
        $this->page = $page + 1;
        $this->pages = ceil($count  / $perPage);
        $this->count = $count;
		$bookIds = array();
		foreach($items as $item){
			$bookIds[] = $item->book_id;
		}
		$this->getCategories();
        $this->getAges();
		$this->getTypes();
		$this->getAuthors($bookIds);
		$this->items = $items;
		$this->checkOpenOrder($items);
	}

    public function expired(){
        $this->partial = 'books';
        $perPage = 20;
        $status = Order_Status::EXPIRED;
        $criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => $status));
        $count = $this->itemDao->count($criteria);
        $page = $this->parsePage("page");
        $items = $this->itemDao->all($criteria->order('id asc')->page($page)->perPage($perPage));
        $this->page = $page + 1;
        $this->pages = ceil($count  / $perPage);
        $this->count = $count;
        $bookIds = array();
        foreach($items as $item){
            $bookIds[] = $item->book_id;
        }
        $this->getCategories();
        $this->getAges();
        $this->getTypes();
        $this->getAuthors($bookIds);
        $this->items = $items;
    }

	public function takenBooks(){
		$this->partial = 'books';
		$perPage = 20;
		$criteria = Db_Criteria::create(array('library_id' => $this->l->id))->add(Db_Exp::in('status', array(Order_Status::TAKEN)));
		$count = $this->itemDao->count($criteria);
		$page = $this->parsePage("page");
		$items = $this->itemDao->all($criteria->order('id asc')->page($page)->perPage($perPage));
		$this->page = $page + 1;
		$this->pages = ceil($count  / $perPage);
		$this->count = $count;
		$bookIds = array();
		foreach($items as $item){
			$bookIds[] = $item->book_id;
		}
		$this->getCategories();
		$this->getAges();
        $this->getTypes();
        $this->getAuthors($bookIds);
		$this->items = $items;	
		$this->checkOpenOrder();
	}

	private function handleOrder($order, $processingItem){
		$firstItem = $this->itemDao->one(Db_Criteria::create(array('status' => Order_Status::NEW_ORDER, 'library_id' => $processingItem->library_id))->add(Db_Exp::gt('id', $processingItem->id))->order('id asc'));
		if($firstItem != null){
			//обновим дату старта обработки
//			$this->itemDao->update($firstItem->id, array('left_time_start' => Util::getLibraryOrderStartTime($processingItem->library_id, date("Y-m-d H:i:s"))));
			$this->itemDao->update($firstItem->id, array('left_time_start' => date("Y-m-d H:i:s")));
        }
		
		$items = $this->itemDao->all(Db_Criteria::create(array('order_id' => $order->id))->order('id asc'));
		$absent = true;
		$bookIds = array();
		foreach($items as $item){
			$bookIds[] = $item->book_id;
			if($item->status == Order_Status::NEW_ORDER){
				return;
			}
			if($item->status == Order_Status::READY){
				$absent = false;
			}
		}
		$date = date("Y-m-d H:i:s");
		if($absent){
			//сразу завершаем заказ
			$this->orderDao->update($order->id, array('confirmed_at' => $date, 'status' => Order_Status::ABSENT));
            $data = array('items' => $items, 'order' => $order, 'authors' => $this->getAuthors($bookIds));

            if (in_array('11', $order->user->roles) || in_array('12', $order->user->roles)) {
                Util::mail($order->user->email, 'en_order_cancelled', "Не удалось оформить заказ", $data);
            } else {
                Util::mail($order->user->email, 'order_cancelled', "Не удалось оформить заказ", $data);
            }

			return;
		}
		
		$this->orderDao->update($order->id, array('confirmed_at' => $date, 'status' => Order_Status::READY));
        $this->orderDao->expired($order);
		
		$mailDao = new Mail_Dao();
		$data = array('order_id' => $order->id);

        if (in_array('11', $order->user->roles) || in_array('12', $order->user->roles)) {
            $mailDao->add($order->user->email, 'enconfirm', $data);
        } else {
            $mailDao->add($order->user->email, 'confirm', $data);
        }
	}
	
	private function finishOrder($order, $item){
		$unhandled = $this->itemDao->one(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::READY)));
		if($unhandled){
			return;
		}

		$libraryUnhandled = $this->itemDao->one(Db_Criteria::create(array('order_id' => $order->id, 'library_id' => $item->library_id, 'status' => Order_Status::READY)));
		if($libraryUnhandled){
			return;
		}

        $this->orderDao->update($order->id, array('status' => Order_Status::TAKEN, 'taken_at' => date("Y-m-d H:i:s")));

        $reviewDao = new Review_Dao();
		$reviewDao->request($order, $item);
	}
	
	private function checkOpenOrder($items = null){
		if($items === null){
			$status = Order_Status::READY;
			$criteria = Db_Criteria::create(array('library_id' => $this->l->id, 'status' => $status));
			$criteria->add(Db_Exp::sql("exists(select * from orders where orders.id = order_id and orders.status = {$status})"));
			$items = $this->itemDao->all($criteria->order('id asc')->perPage(1));
		}
		if($items){
			$this->processedItem = $this->itemDao->one(Db_Criteria::create(array('order_id' => $items[0]->order_id, 'library_id' => $this->l->id))->add(Db_Exp::notIn('status', array(Order_Status::READY, Order_Status::ABSENT))));
		}
	}
}
?>