<?php
class LibraryController extends SiteController
{
	public function __construct(){
		parent::__construct();	
	}
	
	public function one(){
		$library = $this->libraryDao->get(intval($this->route['id']));

        $bytitle = null;
        if(isset($this->route['bytitle'])){
            $bytitle = $this->route['bytitle'];
        }
        $byauthor = null;
        if(isset($this->route['byauthor'])){
            $byauthor = $this->route['byauthor'];
        }
		if($library == null || $library->service == 0){
			throw new PageNotFoundException();
		}
//		$category = null;
//		if(isset($this->route['category'])){
//			$category = $this->categoryDao->get(intval($this->route['category']));
//			if($category == null){
//				throw new PageNotFoundException();
//			}
//		}
        $categories = null;
        if(isset($this->route['category'])){
            $categoriesArr = array_map('intval', explode(',', $this->route['category']));
            $categories = $this->categoryDao->get($categoriesArr);
            if($categories == null){
                throw new PageNotFoundException();
            }
        }
		$age = null;
		if(isset($this->route['age'])){
			$age = $this->ageDao->get(intval($this->route['age']));
			if($age == null){
				throw new PageNotFoundException();
			}
		}
        $type = null;
        if(isset($this->route['type'])){
            $type = $this->typeDao->get(intval($this->route['type']));
            if($type == null){
                throw new PageNotFoundException();
            }
        }
        $region = null;
        if(isset($this->route['region'])){
            $region = $this->route['region'];
            if($region == null){
                throw new PageNotFoundException();
            }
        }
        $district = null;
        if(isset($this->route['district'])){
            $district = $this->route['district'];
            if($district == null){
                throw new PageNotFoundException();
            }
        }
        $metro = null;
        if(isset($this->route['metro'])){
            $metro = $this->route['metro'];
            if($metro == null){
                throw new PageNotFoundException();
            }
        }
        $lang = null;
        if(isset($this->route['lang'])){
            $lang = $this->route['lang'];
            if($lang == null){
                throw new PageNotFoundException();
            }
        }
		$title = isset($_GET['title']) ? $_GET['title'] : null;
		$baseUrl = "/library/{$library->id}/books";
        if($bytitle){
            $baseUrl .= "/bytitle/" . $bytitle;
        }
        if($byauthor){
            $baseUrl .= "/byauthor/" . $byauthor;
        }
//		if($category){
//			$baseUrl .= "/category/" . $category->id;
//		}
        if($categories){
            $baseUrl .= "/category/" . implode(',', $categoriesArr);
        }
		if($age){
			$baseUrl .= "/age/" . $age->id;
		}
        if($type){
            $baseUrl .= "/type/" . $type->id;
        }
        if($region){
            $baseUrl .= "/region/" . $region;
        }
        if($district){
            $baseUrl .= "/district/" . $district;
        }
        if($metro){
            $baseUrl .= "/metro/" . $metro;
        }
        if($lang){
            $baseUrl .= "/lang/" . $lang;
        }
		$this->header = 'library';
		$this->library = $library;
		$this->getBooks($baseUrl, $this->parsePage(), $library, $categories, $title, $age, $type, $bytitle, $byauthor, $region, $district, $metro, $lang, null, true);
		$this->ignoreLibraryFilter = true;
		$this->allLibraries = [];
	}	
}
?>