<?php
class MapController extends SiteController
{
	public function __construct(){
		parent::__construct();		
	}
	
	public function index(){
		$this->header = "map";
		if(isset($_GET['library'])){
			$this->library = $this->libraryDao->get(intval($_GET['library']));
		}
	}
	
	public function library(){
		$this->output = false;
		$this->jsonHeaders();
		$library = $this->libraryDao->get(intval($this->route['library']));
		if($library == null){
			throw new PageNotFoundException();
		}
		echo json_encode(array('type' => 'FeatureCollection', 'features' => array($this->serializeLibrary($library))));
	}
	
	public function json(){
		$this->output = false;
		$this->jsonHeaders();
		$libraries = $this->libraryDao->all(Db_Criteria::create(array('service' => 1, 'published' => 1)));
		
		$result = array();
		foreach($libraries as $l){
			if(!$l->coords){
				continue;
			}
			$result[] = $this->serializeLibrary($l);
		}
		echo json_encode(array('type' => 'FeatureCollection', 'features' => $result));
	}
	
	private function serializeLibrary($l){
		$descr = '<div style="height: 100px;">';
		$descr .= '<b>'.$l->name.'</b><br />';
		if($l->postindex){
			//$descr .= $l->postindex . ', ';
		}
		$descr .= $l->address . '<br />';
		//$descr .= '<p>Телефон: ' . $l->phone . '</p>';
		$descr .= '<a href="/library/'.$l->id.'">Списанные книги этой библиотеки</a>';
		$descr .= '</div>';
		$coords = array_reverse(explode(',', $l->coords));
		return array(
			'type' => 'Feature', 'id' => $l->id,
			'geometry' => array('type' => 'Point', 'coordinates' => $coords),
			'properties' => array('clusterCaption' => $l->name, 'hintContent' => $l->name, 'balloonContent' => $descr)
		);
	}
}
?>