<?php

class OrderController extends SiteController
{

    private $dao;

    public function __construct()
    {
        parent::__construct();
        $this->dao = new Order_Dao();
    }

    public function load()
    {
        $user = Auth_Auth::getUser();
        if ($user == null) {
            throw new PageNotFoundException();
        }
        $order = $this->dao->get(intval($this->route['id']));
        if ($order == null || $order->user_id != $user->id) {
            throw new PageNotFoundException();
        }
        $itemDao = new Order_Item_Dao();
        $items = $itemDao->all(Db_Criteria::create(array('order_id' => $order->id))->order('id asc'));
        $bookIds = array();
        foreach ($items as $item) {
            $bookIds[] = $item->book_id;
        }
        $this->order = $order;
        $this->items = $items;
        $this->getAuthors($bookIds);
        $this->layout = 'order';
    }

    public function refuse()
    {
        $this->output = false;
        $this->jsonHeaders(true);

        $itemDao = new Order_Item_Dao();

        $item = $itemDao->get(intval($_POST['id']));
        if ($item == null || $item->status != Order_Status::READY) {
            throw new PageNotFoundException();
        }
        $order = $item->order;
        $user = Auth_Auth::getUser();
        if ($order == null || $order->status != Order_Status::READY) {
            throw new PageNotFoundException();
        }
        if ($user == null || $order->user_id != $user->id) {
            throw new PageNotFoundException();
        }
        $book = $this->bookDao->get($item->book_id);
        $userDao = new User_Dao();
        $userLibrary = $userDao->one(Db_Criteria::create(array('library_id' => $item->library_id)));
        $itemDao->update($item->id, array('status' => Order_Status::REFUSED));
        $this->bookDao->update($item->book_id, array('status' => Book_Status::ACTIVE));
        Util::mail($userLibrary->email, 'book_refused', "Отказ от книги в заказе № {$order->id}", array('order' => $order, 'book' => $book));

        $activeItemsCount = $itemDao->count(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::READY)));
        if ($activeItemsCount == 0) {
            $takenItemsCount = $itemDao->count(Db_Criteria::create(array('order_id' => $order->id, 'status' => Order_Status::TAKEN)));
            //завершаем заказ. если есть забранные книги, то отмечаем как забранный, иначе как отказ
            $this->dao->update($order->id, array('status' => $takenItemsCount > 0 ? Order_Status::TAKEN : Order_Status::REFUSED));
        }
        echo json_encode(array('status' => 'ok'));
    }

    public function extend()
    {
        $this->output = false;
        $this->jsonHeaders(true);
        $user = Auth_Auth::getUser();
        if ($user == null) {
            echo json_encode(array('status' => 'error'));
            return;
        }
        $order = $this->dao->get(intval($_POST['id']));
        if ($order == null || $order->user_id != $user->id || $order->status != Order_Status::READY) {
            echo json_encode(array('status' => 'error'));
            return;
        }
        if ($order->extend_count < Presets_Dao::fetch('extend_count', 2)) {
            $this->dao->extend($order, Presets_Dao::fetch('extend_days', 2));
        }
        echo json_encode(array('status' => 'ok'));
    }

    public function generic($data)
    {
        $currentUser = Auth_Auth::getUser();
        if ($currentUser == null || !$currentUser->isInRole(Roles::LIBRARY)) {
            throw new PageNotFoundException();
        }
        foreach ($data as $k => $v) {
            $data[$k] = Util::filterStr($v);
        }
        $login = 'generic_' . $currentUser->library_id . '_' . time();
        $userData = array('login' => $login, 'password' => '123', 'email' => $login . '@generic.gen', 'name' => $data['name']);
//        $userData['phone'] = '7' . preg_replace('/\D/', '', $data['phone']);
//        if ($userData['phone'] == '7') {
            $userData['phone'] = null;
//        }
//        $bd = explode('/', $data['birth_date']);
//        $userData['birth_date'] = date('Y-m-d', strtotime(join('-', array_reverse($bd))));
        $userData['age'] = intval($data['age']);
        $userData['reader'] = intval($data['reader']);
        $userData['gender'] = intval($data['gender']);
        $user = $this->userDao->register($userData, array(Roles::GENERIC));

        $ids = $this->cart->get();
        $this->cart->clear();
        $books = $this->bookDao->get($ids);
        if (!$books) {
            $this->addFormError("name", "failed");
            return;
        }
        $number = $this->dao->order($user->id, $books, true);
        $this->addFormData('order', $number);
        if (!$number) {
            $this->addFormError("name", "failed");
            return;
        }
    }

    public function order()
    {
        $this->output = false;
        $this->jsonHeaders(true);
        $user = Auth_Auth::getUser();
        if ($user == null) {
            echo json_encode(array('status' => 'error'));
            return;
        }
        $result = $this->doOrder($user);
        if ($result === true) {
            echo json_encode(array('status' => 'ok'));
        } else {
            echo json_encode(array('status' => 'error', 'error' => $result));
        }
    }

    protected function doOrder($user)
    {
        $ids = $this->cart->get();
        if (!$ids) {
            return 'Ваша корзина пуста';
        }
//        $limit = Presets_Dao::fetch('daily_limit', 10);
        $aLimit = 10; // All Other books limit per day
        $eLimit = 100; // Exchange books limit per day

        $singleBook = $this->bookDao->get($ids[0]);

        if ($singleBook->fund_type == Book_Fund::ALLOTHER){
            $aN = count($ids) + $this->dao->getBooksCount($user->id);
            if ($aN > $aLimit) {
                return 'В день вы можете заказывать не более ' . $aLimit . ' книг';
            }
        } elseif ($singleBook->fund_type == Book_Fund::EXCHANGE){
            $eN = count($ids) + $this->dao->getExBooksCount($user->id);
            if ($eN > $eLimit) {
                return 'В день вы можете заказывать не более ' . $eLimit . ' книг';
            }
        }
//        $n = count($ids) + $this->dao->getDayOrderCount($user->id);
//        if ($n > $limit) {
//            return 'В день вы можете заказывать ' . $limit . ' книг';
//        }

        $books = $this->bookDao->get($ids);
        if (empty($books)) {
            error_log(join(', ', $ids) . ' failed find books');
            return 'Книги не найдены';
        }
        foreach ($books as $book) {
//            if ($book->age_category->adult && strtotime($user->birth_date) > strtotime('-18 years')) {
            if ($book->age_category_id === 1 && ($user->age === 0 || $user->age === 1)) {
                return 'Оформление заказа невозможно. Вы выбрали книги возрастной категории "Взрослый"';
            }
        }
        $number = $this->dao->order($user->id, $books);
        if (!$number) {
            return "";
        }
        $this->cart->clear();
        $mailDao = new Mail_Dao();

        if (in_array('11', $user->roles) || in_array('12', $user->roles)) {
            $mailDao->add($user->email, 'entityorder', $ids);
        } else {
            $mailDao->add($user->email, 'order', $ids);
        }

        return true;
    }
}

?>